/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.receipt.AddressResolutionStatement;
import io.nem.symbol.sdk.model.receipt.ArtifactExpiryReceipt;
import io.nem.symbol.sdk.model.receipt.BalanceChangeReceipt;
import io.nem.symbol.sdk.model.receipt.BalanceTransferReceipt;
import io.nem.symbol.sdk.model.receipt.InflationReceipt;
import io.nem.symbol.sdk.model.receipt.MosaicResolutionStatement;
import io.nem.symbol.sdk.model.receipt.Receipt;
import io.nem.symbol.sdk.model.receipt.ReceiptSource;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import io.nem.symbol.sdk.model.receipt.ResolutionEntry;
import io.nem.symbol.sdk.model.receipt.TransactionStatement;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.openapi.vertx.model.BalanceChangeReceiptDTO;
import io.nem.symbol.sdk.openapi.vertx.model.BalanceTransferReceiptDTO;
import io.nem.symbol.sdk.openapi.vertx.model.InflationReceiptDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicExpiryReceiptDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceExpiryReceiptDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ResolutionStatementDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ResolutionStatementInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatementInfoDTO;
import java.util.stream.Collectors;

public class ReceiptMappingVertx {
    private final JsonHelper jsonHelper;

    public ReceiptMappingVertx(JsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }

    public AddressResolutionStatement createAddressResolutionStatementFromDto(ResolutionStatementInfoDTO receiptDto) {
        ResolutionStatementDTO statement = receiptDto.getStatement();
        return new AddressResolutionStatement(receiptDto.getId(), statement.getHeight(), MapperUtils.toUnresolvedAddress((String)statement.getUnresolved()), statement.getResolutionEntries().stream().map(entry -> ResolutionEntry.forAddress((Address)MapperUtils.toAddress((String)entry.getResolved()), (ReceiptSource)new ReceiptSource(entry.getSource().getPrimaryId().longValue(), entry.getSource().getSecondaryId().longValue()))).collect(Collectors.toList()));
    }

    public MosaicResolutionStatement createMosaicResolutionStatementFromDto(ResolutionStatementInfoDTO receiptDto) {
        ResolutionStatementDTO statement = receiptDto.getStatement();
        return new MosaicResolutionStatement(receiptDto.getId(), statement.getHeight(), MapperUtils.toUnresolvedMosaicId((String)statement.getUnresolved()), statement.getResolutionEntries().stream().map(entry -> ResolutionEntry.forMosaicId((MosaicId)MapperUtils.toMosaicId((String)entry.getResolved()), (ReceiptSource)new ReceiptSource(entry.getSource().getPrimaryId().longValue(), entry.getSource().getSecondaryId().longValue()))).collect(Collectors.toList()));
    }

    public TransactionStatement createTransactionStatement(TransactionStatementInfoDTO input) {
        return new TransactionStatement(input.getId(), input.getStatement().getHeight(), new ReceiptSource(input.getStatement().getSource().getPrimaryId().longValue(), input.getStatement().getSource().getSecondaryId().longValue()), input.getStatement().getReceipts().stream().map(this::createReceiptFromDto).collect(Collectors.toList()));
    }

    public Receipt createReceiptFromDto(Object receiptDto) {
        ReceiptType type = ReceiptType.rawValueOf((int)this.jsonHelper.getInteger(receiptDto, new String[]{"type"}));
        switch (type) {
            case HARVEST_FEE: 
            case LOCK_HASH_CREATED: 
            case LOCK_HASH_COMPLETED: 
            case LOCK_HASH_EXPIRED: 
            case LOCK_SECRET_CREATED: 
            case LOCK_SECRET_COMPLETED: 
            case LOCK_SECRET_EXPIRED: {
                return this.createBalanceChangeReceipt((BalanceChangeReceiptDTO)this.jsonHelper.convert(receiptDto, BalanceChangeReceiptDTO.class, new String[0]));
            }
            case MOSAIC_RENTAL_FEE: 
            case NAMESPACE_RENTAL_FEE: {
                return this.createBalanceTransferRecipient((BalanceTransferReceiptDTO)this.jsonHelper.convert(receiptDto, BalanceTransferReceiptDTO.class, new String[0]));
            }
            case MOSAIC_EXPIRED: {
                return this.createArtifactExpiryReceipt((MosaicExpiryReceiptDTO)this.jsonHelper.convert(receiptDto, MosaicExpiryReceiptDTO.class, new String[0]), type);
            }
            case NAMESPACE_EXPIRED: 
            case NAMESPACE_DELETED: {
                return this.createArtifactExpiryReceipt((NamespaceExpiryReceiptDTO)this.jsonHelper.convert(receiptDto, NamespaceExpiryReceiptDTO.class, new String[0]), type);
            }
            case INFLATION: {
                return this.createInflationReceipt((InflationReceiptDTO)this.jsonHelper.convert(receiptDto, InflationReceiptDTO.class, new String[0]));
            }
        }
        throw new IllegalArgumentException("Receipt type: " + type.name() + " not valid");
    }

    public ArtifactExpiryReceipt<NamespaceId> createArtifactExpiryReceipt(NamespaceExpiryReceiptDTO receipt, ReceiptType type) {
        return new ArtifactExpiryReceipt((Object)MapperUtils.toNamespaceId((String)receipt.getArtifactId()), type, ReceiptVersion.ARTIFACT_EXPIRY);
    }

    public ArtifactExpiryReceipt<MosaicId> createArtifactExpiryReceipt(MosaicExpiryReceiptDTO receipt, ReceiptType type) {
        return new ArtifactExpiryReceipt((Object)MapperUtils.toMosaicId((String)receipt.getArtifactId()), type, ReceiptVersion.ARTIFACT_EXPIRY);
    }

    public BalanceChangeReceipt createBalanceChangeReceipt(BalanceChangeReceiptDTO receipt) {
        return new BalanceChangeReceipt(MapperUtils.toAddress((String)receipt.getTargetAddress()), new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.BALANCE_CHANGE);
    }

    public BalanceTransferReceipt createBalanceTransferRecipient(BalanceTransferReceiptDTO receipt) {
        return new BalanceTransferReceipt(MapperUtils.toAddress((String)receipt.getSenderAddress()), Address.createFromEncoded((String)receipt.getRecipientAddress()), new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.BALANCE_TRANSFER);
    }

    public InflationReceipt createInflationReceipt(InflationReceiptDTO receipt) {
        return new InflationReceipt(new MosaicId(receipt.getMosaicId()), receipt.getAmount(), ReceiptType.rawValueOf((int)receipt.getType().getValue()), ReceiptVersion.INFLATION_RECEIPT);
    }
}

