/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.MetadataRepository;
import io.nem.symbol.sdk.api.MetadataSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.metadata.Metadata;
import io.nem.symbol.sdk.model.metadata.MetadataType;
import io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntryDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MetadataRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MetadataRepository {
    private final MetadataRoutesApi client;

    public MetadataRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new MetadataRoutesApiImpl(apiClient);
    }

    public Observable<Page<Metadata>> search(MetadataSearchCriteria criteria) {
        String sourceAddress = this.toDto(criteria.getSourceAddress());
        String targetAddress = this.toDto(criteria.getTargetAddress());
        String scopedMetadataKey = this.toDto(criteria.getScopedMetadataKey());
        String targetId = criteria.getTargetId();
        MetadataTypeEnum metadataType = criteria.getMetadataType() == null ? null : MetadataTypeEnum.fromValue((Integer)criteria.getMetadataType().getValue());
        String offset = criteria.getOffset();
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        Order order = this.toDto(criteria.getOrder());
        Consumer callback = handler -> this.getClient().searchMetadataEntries(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order, handler);
        return this.exceptionHandling(this.call(callback).map(page -> this.toPage(page.getPagination(), page.getData().stream().map(this::toMetadata).collect(Collectors.toList()))));
    }

    public MetadataRoutesApi getClient() {
        return this.client;
    }

    private Metadata toMetadata(MetadataInfoDTO dto) {
        MetadataEntryDTO entryDto = dto.getMetadataEntry();
        return new Metadata(dto.getId(), entryDto.getCompositeHash(), MapperUtils.toAddress((String)entryDto.getSourceAddress()), MapperUtils.toAddress((String)entryDto.getTargetAddress()), new BigInteger(entryDto.getScopedMetadataKey(), 16), MetadataType.rawValueOf((int)entryDto.getMetadataType().getValue()), ConvertUtils.fromHexToString((String)entryDto.getValue()), Optional.ofNullable(Objects.toString(entryDto.getTargetId(), null)));
    }
}

