/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.BlockOrderBy;
import io.nem.symbol.sdk.api.BlockRepository;
import io.nem.symbol.sdk.api.BlockSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.BlockInfo;
import io.nem.symbol.sdk.model.blockchain.MerklePathItem;
import io.nem.symbol.sdk.model.blockchain.MerkleProofInfo;
import io.nem.symbol.sdk.model.blockchain.Position;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BlockRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements BlockRepository {
    private final BlockRoutesApi client;

    public BlockRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new BlockRoutesApiImpl(apiClient);
    }

    public Observable<BlockInfo> getBlockByHeight(BigInteger height) {
        Consumer callback = handler -> this.getClient().getBlockByHeight(height, handler);
        return this.exceptionHandling(this.call(callback).map(BlockRepositoryVertxImpl::toBlockInfo));
    }

    public Observable<Page<BlockInfo>> search(BlockSearchCriteria criteria) {
        Consumer callback = handler -> this.getClient().searchBlocks(this.toDto(criteria.getSignerPublicKey()), this.toDto(criteria.getBeneficiaryAddress()), criteria.getPageSize(), criteria.getPageNumber(), criteria.getOffset(), this.toDto(criteria.getOrder()), this.toDto(criteria.getOrderBy()), handler);
        return this.exceptionHandling(this.call(callback).map(mosaicPage -> this.toPage(mosaicPage.getPagination(), mosaicPage.getData().stream().map(BlockRepositoryVertxImpl::toBlockInfo).collect(Collectors.toList()))));
    }

    private BlockOrderByEnum toDto(BlockOrderBy orderBy) {
        return orderBy == null ? null : BlockOrderByEnum.fromValue((String)orderBy.getValue());
    }

    public Observable<MerkleProofInfo> getMerkleTransaction(BigInteger height, String hash) {
        Consumer callback = handler -> this.client.getMerkleTransaction(height, hash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toMerkleProofInfo));
    }

    private MerkleProofInfo toMerkleProofInfo(MerkleProofInfoDTO dto) {
        List pathItems = dto.getMerklePath().stream().map(pathItem -> new MerklePathItem(pathItem.getPosition() == null ? null : Position.rawValueOf((String)pathItem.getPosition().getValue()), pathItem.getHash())).collect(Collectors.toList());
        return new MerkleProofInfo(pathItems);
    }

    public Observable<MerkleProofInfo> getMerkleReceipts(BigInteger height, String hash) {
        Consumer callback = handler -> this.getClient().getMerkleReceipts(height, hash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toMerkleProofInfo));
    }

    public static BlockInfo toBlockInfo(BlockInfoDTO blockInfoDTO) {
        NetworkType networkType = NetworkType.rawValueOf((int)blockInfoDTO.getBlock().getNetwork().getValue());
        return new BlockInfo(blockInfoDTO.getId(), blockInfoDTO.getBlock().getSize(), blockInfoDTO.getMeta().getHash(), blockInfoDTO.getMeta().getGenerationHash(), blockInfoDTO.getMeta().getTotalFee(), blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), blockInfoDTO.getMeta().getNumTransactions(), Optional.ofNullable(blockInfoDTO.getMeta().getNumStatements()), blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), blockInfoDTO.getBlock().getSignature(), PublicAccount.createFromPublicKey((String)blockInfoDTO.getBlock().getSignerPublicKey(), (NetworkType)networkType), networkType, blockInfoDTO.getBlock().getVersion(), blockInfoDTO.getBlock().getType().intValue(), blockInfoDTO.getBlock().getHeight(), blockInfoDTO.getBlock().getTimestamp(), blockInfoDTO.getBlock().getDifficulty(), blockInfoDTO.getBlock().getFeeMultiplier(), blockInfoDTO.getBlock().getPreviousBlockHash(), blockInfoDTO.getBlock().getTransactionsHash(), blockInfoDTO.getBlock().getReceiptsHash(), blockInfoDTO.getBlock().getStateHash(), blockInfoDTO.getBlock().getProofGamma(), blockInfoDTO.getBlock().getProofScalar(), blockInfoDTO.getBlock().getProofVerificationHash(), Address.createFromEncoded((String)blockInfoDTO.getBlock().getBeneficiaryAddress()));
    }

    public BlockRoutesApi getClient() {
        return this.client;
    }
}

