/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.AccountRepository;
import io.nem.symbol.sdk.api.AccountSearchCriteria;
import io.nem.symbol.sdk.api.Page;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.AccountInfo;
import io.nem.symbol.sdk.model.account.AccountLinkVotingKey;
import io.nem.symbol.sdk.model.account.AccountType;
import io.nem.symbol.sdk.model.account.ActivityBucket;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.SupplementalAccountKeys;
import io.nem.symbol.sdk.model.mosaic.ResolvedMosaic;
import io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.SupplementalPublicKeysDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AccountRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements AccountRepository {
    private final AccountRoutesApi client;

    public AccountRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new AccountRoutesApiImpl(apiClient);
    }

    public Observable<AccountInfo> getAccountInfo(Address address) {
        Consumer callback = handler -> this.getClient().getAccountInfo(address.plain(), handler);
        return this.exceptionHandling(this.call(callback).map(this::toAccountInfo));
    }

    public Observable<List<AccountInfo>> getAccountsInfo(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getAccountsInfo(accountIds, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toAccountInfo).toList().toObservable());
    }

    private AccountInfo toAccountInfo(AccountInfoDTO accountInfoDTO) {
        AccountDTO accountDTO = accountInfoDTO.getAccount();
        return new AccountInfo(accountInfoDTO.getId(), MapperUtils.toAddress((String)accountDTO.getAddress()), accountDTO.getAddressHeight(), accountDTO.getPublicKey(), accountDTO.getPublicKeyHeight(), accountDTO.getImportance(), accountDTO.getImportanceHeight(), accountDTO.getMosaics().stream().map(mosaicDTO -> new ResolvedMosaic(MapperUtils.toMosaicId((String)mosaicDTO.getId()), mosaicDTO.getAmount())).collect(Collectors.toList()), AccountType.rawValueOf((int)accountDTO.getAccountType().getValue()), this.toDto(accountDTO.getSupplementalPublicKeys()), accountDTO.getActivityBuckets().stream().map(dto -> new ActivityBucket(dto.getStartHeight(), dto.getTotalFeesPaid(), dto.getBeneficiaryCount().longValue(), dto.getRawScore())).collect(Collectors.toList()));
    }

    public Observable<Page<AccountInfo>> search(AccountSearchCriteria criteria) {
        Integer pageSize = criteria.getPageSize();
        Integer pageNumber = criteria.getPageNumber();
        String offset = criteria.getOffset();
        Order order = this.toDto(criteria.getOrder());
        AccountOrderByEnum orderBy = criteria.getOrderBy() == null ? null : AccountOrderByEnum.fromValue((String)criteria.getOrderBy().getValue());
        String mosaicId = criteria.getMosaicId() == null ? null : criteria.getMosaicId().getIdAsHex();
        Consumer callback = handler -> this.getClient().searchAccounts(pageSize, pageNumber, offset, order, orderBy, mosaicId, handler);
        return this.exceptionHandling(this.call(callback).map(page -> this.toPage(page.getPagination(), page.getData().stream().map(this::toAccountInfo).collect(Collectors.toList()))));
    }

    private SupplementalAccountKeys toDto(SupplementalPublicKeysDTO dto) {
        if (dto == null) {
            return new SupplementalAccountKeys(Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
        }
        Optional<Object> linked = Optional.ofNullable(dto.getLinked() == null ? null : dto.getLinked().getPublicKey());
        Optional<Object> node = Optional.ofNullable(dto.getNode() == null ? null : dto.getNode().getPublicKey());
        Optional<Object> vrf = Optional.ofNullable(dto.getVrf() == null ? null : dto.getVrf().getPublicKey());
        List voting = dto.getVoting() == null || dto.getVoting().getPublicKeys() == null ? Collections.emptyList() : dto.getVoting().getPublicKeys().stream().map(p -> new AccountLinkVotingKey(p.getPublicKey(), new BigInteger(p.getStartPoint()), new BigInteger(p.getEndPoint()))).collect(Collectors.toList());
        return new SupplementalAccountKeys(linked, node, vrf, voting);
    }

    private AccountRoutesApi getClient() {
        return this.client;
    }
}

