/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.message.Message;
import io.nem.symbol.sdk.model.message.MessageType;
import io.nem.symbol.sdk.model.message.PlainMessage;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.TransferTransaction;
import io.nem.symbol.sdk.model.transaction.TransferTransactionFactory;
import io.nem.symbol.sdk.openapi.vertx.model.MessageDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MessageTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransferTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.UnresolvedMosaic;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class TransferTransactionMapper
extends AbstractTransactionMapper<TransferTransactionDTO, TransferTransaction> {
    public TransferTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.TRANSFER, TransferTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<TransferTransaction> createFactory(NetworkType networkType, TransferTransactionDTO transaction) {
        List<Object> mosaics = new ArrayList();
        if (transaction.getMosaics() != null) {
            mosaics = transaction.getMosaics().stream().map(mosaic -> new Mosaic(MapperUtils.toUnresolvedMosaicId((String)mosaic.getId()), mosaic.getAmount())).collect(Collectors.toList());
        }
        Message message = Optional.ofNullable(transaction.getMessage()).map(m -> Message.createFromPayload((MessageType)MessageType.rawValueOf((int)m.getType().getValue()), (String)m.getPayload())).orElse((Message)PlainMessage.Empty);
        return TransferTransactionFactory.create((NetworkType)networkType, (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()), mosaics, (Message)message);
    }

    @Override
    protected void copyToDto(TransferTransaction transaction, TransferTransactionDTO dto) {
        List<Object> mosaics = new ArrayList();
        if (transaction.getMosaics() != null) {
            mosaics = transaction.getMosaics().stream().map(mosaic -> {
                UnresolvedMosaic mosaicDto = new UnresolvedMosaic();
                mosaicDto.setAmount(mosaic.getAmount());
                mosaicDto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)mosaic.getId()));
                return mosaicDto;
            }).collect(Collectors.toList());
        }
        MessageDTO message = null;
        if (transaction.getMessage() != null) {
            message = new MessageDTO();
            message.setType(MessageTypeEnum.NUMBER_0);
            message.setPayload(ConvertUtils.toHex((byte[])transaction.getMessage().getPayload().getBytes(StandardCharsets.UTF_8)));
        }
        dto.setRecipientAddress(transaction.getRecipient().encoded(transaction.getNetworkType()));
        dto.setMosaics(mosaics);
        dto.setMessage(message);
    }
}

