/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.HashLockTransaction;
import io.nem.symbol.sdk.model.transaction.HashLockTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockTransactionDTO;
import java.math.BigInteger;

class HashLockTransactionMapper
extends AbstractTransactionMapper<HashLockTransactionDTO, HashLockTransaction> {
    public HashLockTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.HASH_LOCK, HashLockTransactionDTO.class);
    }

    private Mosaic getMosaic(HashLockTransactionDTO mosaic) {
        return new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)mosaic.getMosaicId()), mosaic.getAmount());
    }

    @Override
    protected TransactionFactory<HashLockTransaction> createFactory(NetworkType networkType, HashLockTransactionDTO transaction) {
        return HashLockTransactionFactory.create((NetworkType)networkType, (Mosaic)this.getMosaic(transaction), (BigInteger)transaction.getDuration(), (String)transaction.getHash());
    }

    @Override
    protected void copyToDto(HashLockTransaction transaction, HashLockTransactionDTO dto) {
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaic().getId()));
        dto.setAmount(transaction.getMosaic().getAmount());
        dto.setDuration(transaction.getDuration());
        dto.setHash(transaction.getHash());
    }
}

