/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.AliasAction;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AddressAliasTransaction;
import io.nem.symbol.sdk.model.transaction.AddressAliasTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AddressAliasTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AliasActionEnum;

class AddressAliasTransactionMapper
extends AbstractTransactionMapper<AddressAliasTransactionDTO, AddressAliasTransaction> {
    public AddressAliasTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ADDRESS_ALIAS, AddressAliasTransactionDTO.class);
    }

    protected AddressAliasTransactionFactory createFactory(NetworkType networkType, AddressAliasTransactionDTO transaction) {
        NamespaceId namespaceId = MapperUtils.toNamespaceId((String)transaction.getNamespaceId());
        AliasAction aliasAction = AliasAction.rawValueOf((byte)transaction.getAliasAction().getValue().byteValue());
        return AddressAliasTransactionFactory.create((NetworkType)networkType, (AliasAction)aliasAction, (NamespaceId)namespaceId, (Address)MapperUtils.toAddress((String)transaction.getAddress()));
    }

    @Override
    protected void copyToDto(AddressAliasTransaction transaction, AddressAliasTransactionDTO dto) {
        dto.setAddress(transaction.getAddress().encoded());
        dto.setNamespaceId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getNamespaceId()));
        dto.setAliasAction(AliasActionEnum.fromValue((Integer)Integer.valueOf(transaction.getAliasAction().getValue())));
    }
}

