/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.TransactionStatusRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.TransactionState;
import io.nem.symbol.sdk.model.transaction.TransactionStatus;
import io.nem.symbol.sdk.openapi.vertx.api.TransactionStatusRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.TransactionStatusRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatusDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.function.Consumer;

public class TransactionStatusRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements TransactionStatusRepository {
    private final TransactionStatusRoutesApi client;

    public TransactionStatusRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new TransactionStatusRoutesApiImpl(apiClient);
    }

    public TransactionStatusRoutesApi getClient() {
        return this.client;
    }

    public Observable<TransactionStatus> getTransactionStatus(String transactionHash) {
        Consumer callback = handler -> this.getClient().getTransactionStatus(transactionHash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toTransactionStatus));
    }

    private TransactionStatus toTransactionStatus(TransactionStatusDTO transactionStatusDTO) {
        return new TransactionStatus(TransactionState.valueOf((String)transactionStatusDTO.getGroup().name()), transactionStatusDTO.getCode() == null ? null : transactionStatusDTO.getCode().getValue(), transactionStatusDTO.getHash(), new Deadline(transactionStatusDTO.getDeadline()), transactionStatusDTO.getHeight());
    }

    public Observable<List<TransactionStatus>> getTransactionStatuses(List<String> transactionHashes) {
        Consumer callback = handler -> this.client.getTransactionStatuses(new TransactionHashes().hashes(transactionHashes), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransactionStatus).toList().toObservable());
    }
}

