/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.MetadataRepository;
import io.nem.symbol.sdk.api.QueryParams;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.metadata.Metadata;
import io.nem.symbol.sdk.model.metadata.MetadataEntry;
import io.nem.symbol.sdk.model.metadata.MetadataType;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntryDTO;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MetadataRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MetadataRepository {
    private final MetadataRoutesApi client;

    public MetadataRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new MetadataRoutesApiImpl(apiClient);
    }

    public Observable<List<Metadata>> getAccountMetadata(Address targetAddress, Optional<QueryParams> queryParams) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getAccountMetadata(targetAddress.plain(), this.getPageSize(queryParams), this.getOrder(queryParams), this.getId(queryParams), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getAccountMetadataByKey(Address targetAddress, BigInteger key) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getAccountMetadataByKey(targetAddress.plain(), this.toHex(key), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getMosaicMetadata(MosaicId targetMosaicId, Optional<QueryParams> queryParams) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getMosaicMetadata(targetMosaicId.getIdAsHex(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getMosaicMetadataByKey(MosaicId targetMosaicId, BigInteger key) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getMosaicMetadataByKey(targetMosaicId.getIdAsHex(), this.toHex(key), handler);
        return this.handleList(callback);
    }

    public Observable<Metadata> getAccountMetadataByKeyAndSender(Address targetAddress, BigInteger key, Address sourceAddress) {
        Consumer<Handler<AsyncResult<MetadataDTO>>> callback = handler -> this.getClient().getAccountMetadataByKeyAndSender(targetAddress.plain(), this.toHex(key), sourceAddress.plain(), handler);
        return this.handleOne(callback);
    }

    public Observable<Metadata> getMosaicMetadataByKeyAndSender(MosaicId targetMosaicId, BigInteger key, Address sourceAddress) {
        Consumer<Handler<AsyncResult<MetadataDTO>>> callback = handler -> this.getClient().getMosaicMetadataByKeyAndSender(targetMosaicId.getIdAsHex(), this.toHex(key), sourceAddress.plain(), handler);
        return this.handleOne(callback);
    }

    public Observable<List<Metadata>> getNamespaceMetadata(NamespaceId targetNamespaceId, Optional<QueryParams> queryParams) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getNamespaceMetadata(targetNamespaceId.getIdAsHex(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams), handler);
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getNamespaceMetadataByKey(NamespaceId targetNamespaceId, BigInteger key) {
        Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback = handler -> this.getClient().getNamespaceMetadataByKey(targetNamespaceId.getIdAsHex(), this.toHex(key), handler);
        return this.handleList(callback);
    }

    public Observable<Metadata> getNamespaceMetadataByKeyAndSender(NamespaceId targetNamespaceId, BigInteger key, Address sourceAddress) {
        Consumer<Handler<AsyncResult<MetadataDTO>>> callback = handler -> this.getClient().getNamespaceMetadataByKeyAndSender(targetNamespaceId.getIdAsHex(), this.toHex(key), sourceAddress.plain(), handler);
        return this.handleOne(callback);
    }

    public MetadataRoutesApi getClient() {
        return this.client;
    }

    private Observable<List<Metadata>> handleList(Consumer<Handler<AsyncResult<MetadataEntriesDTO>>> callback) {
        return this.exceptionHandling(this.call(callback).map(MetadataEntriesDTO::getMetadataEntries).flatMapIterable(item -> item).map(this::toMetadata).toList().toObservable());
    }

    private Observable<Metadata> handleOne(Consumer<Handler<AsyncResult<MetadataDTO>>> callback) {
        return this.exceptionHandling(this.call(callback).map(this::toMetadata));
    }

    private Metadata toMetadata(MetadataDTO dto) {
        MetadataEntryDTO entryDto = dto.getMetadataEntry();
        MetadataEntry metadataEntry = new MetadataEntry(entryDto.getCompositeHash(), MapperUtils.toAddress((String)entryDto.getSourceAddress()), MapperUtils.toAddress((String)entryDto.getTargetAddress()), new BigInteger(entryDto.getScopedMetadataKey(), 16), MetadataType.rawValueOf((int)entryDto.getMetadataType().getValue()), ConvertUtils.fromHexToString((String)entryDto.getValue()), Optional.ofNullable(Objects.toString(entryDto.getTargetId(), null)));
        return new Metadata(dto.getId(), metadataEntry);
    }

    protected String toHex(BigInteger key) {
        return ConvertUtils.toSize16Hex((BigInteger)key);
    }
}

