/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class JsonHelperJackson2
implements JsonHelper {
    private final ObjectMapper objectMapper;

    public JsonHelperJackson2(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonHelperJackson2() {
        this(JsonHelperJackson2.configureMapper(new ObjectMapper()));
    }

    public static ObjectMapper configureMapper(ObjectMapper objectMapper) {
        objectMapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        objectMapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(BigInteger.class, (JsonSerializer)new BigIntegerSerializer());
        objectMapper.registerModule((Module)module);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        objectMapper.registerModule((Module)new Jdk8Module());
        return objectMapper;
    }

    public Object parse(String string) {
        return this.parse(string, ObjectNode.class);
    }

    public <T> T parse(String string, Class<T> clazz) {
        try {
            if (StringUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            return (T)this.objectMapper.readValue(string, clazz);
        }
        catch (Exception e) {
            throw JsonHelperJackson2.handleException(e, "Json payload: " + string);
        }
    }

    public String print(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String prettyPrint(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (IOException e) {
            throw JsonHelperJackson2.handleException(e, null);
        }
    }

    private static IllegalArgumentException handleException(Exception e, String extraMessage) {
        String message = ExceptionUtils.getMessage((Throwable)e);
        if (StringUtils.isNotBlank((CharSequence)extraMessage)) {
            message = message + ". " + extraMessage;
        }
        return new IllegalArgumentException(message, e);
    }

    public <T> T convert(Object object, Class<T> instanceClass, String ... path) {
        Object child;
        Object object2 = child = path.length == 0 ? object : this.getNode(this.convert(object, JsonNode.class, new String[0]), path);
        if (child == null) {
            return null;
        }
        if (instanceClass.isInstance(child)) {
            return (T)child;
        }
        return this.parse(this.print(child), instanceClass);
    }

    public Integer getInteger(Object object, String ... path) {
        JsonNode child = this.getNode(this.convert(object, JsonNode.class, new String[0]), path);
        if (child == null || child.isNull()) {
            return null;
        }
        if (child.isObject()) {
            throw new IllegalArgumentException("Cannot extract an Integer from an json object");
        }
        return child.asInt();
    }

    public String getString(Object object, String ... path) {
        JsonNode child = this.getNode(this.convert(object, JsonNode.class, new String[0]), path);
        if (child == null || child.isNull()) {
            return null;
        }
        if (child.isObject()) {
            throw new IllegalArgumentException("Cannot extract a String from an json object");
        }
        return child.asText();
    }

    public Long getLong(Object object, String ... path) {
        JsonNode child = this.getNode(this.convert(object, JsonNode.class, new String[0]), path);
        if (child == null || child.isNull()) {
            return null;
        }
        if (child.isObject()) {
            throw new IllegalArgumentException("Cannot extract a Long from an json object");
        }
        return child.asLong();
    }

    public Boolean getBoolean(Object object, String ... path) {
        JsonNode child = this.getNode(this.convert(object, JsonNode.class, new String[0]), path);
        if (child == null || child.isNull()) {
            return null;
        }
        if (child.isObject()) {
            throw new IllegalArgumentException("Cannot extract a Boolean from an json object");
        }
        return child.booleanValue();
    }

    public BigInteger getBigInteger(Object object, String ... path) {
        String string = this.getString(object, path);
        if (string == null) {
            return null;
        }
        return new BigInteger(string);
    }

    public boolean contains(Object object, String ... path) {
        JsonNode child = this.getNode(this.convert(object, JsonNode.class, new String[0]), path);
        return child != null && !child.isNull();
    }

    private JsonNode getNode(JsonNode parent, String ... path) {
        JsonNode child = parent;
        if (child == null) {
            return null;
        }
        if (path.length == 0) {
            return child;
        }
        if (!child.isObject()) {
            return null;
        }
        int index = 0;
        for (String attribute : path) {
            if ((child = child.get(attribute)) == null) {
                return null;
            }
            if (++index >= path.length || child.isObject()) continue;
            return null;
        }
        return child;
    }

    public static class BigIntegerSerializer
    extends StdSerializer<BigInteger> {
        public BigIntegerSerializer() {
            super(BigInteger.class);
        }

        public void serialize(BigInteger value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.toString());
            }
        }
    }
}

