/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.VotingKey;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.VotingKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.VotingKeyLinkTransactionFactory;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.VotingKeyLinkTransactionDTO;

public class VotingKeyLinkTransactionMapper
extends AbstractTransactionMapper<VotingKeyLinkTransactionDTO, VotingKeyLinkTransaction> {
    public VotingKeyLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.VOTING_KEY_LINK, VotingKeyLinkTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<VotingKeyLinkTransaction> createFactory(NetworkType networkType, VotingKeyLinkTransactionDTO transaction) {
        VotingKey linkedPublicKey = VotingKey.fromHexString((String)transaction.getLinkedPublicKey());
        LinkAction linkAction = LinkAction.rawValueOf((int)transaction.getLinkAction().getValue());
        return VotingKeyLinkTransactionFactory.create((NetworkType)networkType, (VotingKey)linkedPublicKey, (LinkAction)linkAction);
    }

    @Override
    protected void copyToDto(VotingKeyLinkTransaction transaction, VotingKeyLinkTransactionDTO dto) {
        dto.setLinkAction(LinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
        dto.setLinkedPublicKey(transaction.getLinkedPublicKey().toHex());
    }
}

