/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.NamespaceRegistrationTransaction;
import io.nem.symbol.sdk.model.transaction.NamespaceRegistrationTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTypeEnum;
import java.math.BigInteger;
import java.util.Optional;

class NamespaceRegistrationTransactionMapper
extends AbstractTransactionMapper<NamespaceRegistrationTransactionDTO, NamespaceRegistrationTransaction> {
    public NamespaceRegistrationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.NAMESPACE_REGISTRATION, NamespaceRegistrationTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<NamespaceRegistrationTransaction> createFactory(NetworkType networkType, NamespaceRegistrationTransactionDTO transaction) {
        NamespaceRegistrationType namespaceRegistrationType = NamespaceRegistrationType.rawValueOf((int)transaction.getRegistrationType().getValue());
        return NamespaceRegistrationTransactionFactory.create((NetworkType)networkType, (String)transaction.getName(), (NamespaceId)MapperUtils.toNamespaceId((String)transaction.getId()), (NamespaceRegistrationType)namespaceRegistrationType, namespaceRegistrationType == NamespaceRegistrationType.ROOT_NAMESPACE ? Optional.of(transaction.getDuration()) : Optional.empty(), namespaceRegistrationType == NamespaceRegistrationType.SUB_NAMESPACE ? Optional.of(MapperUtils.toNamespaceId((String)transaction.getParentId())) : Optional.empty());
    }

    @Override
    protected void copyToDto(NamespaceRegistrationTransaction transaction, NamespaceRegistrationTransactionDTO dto) {
        dto.setName(transaction.getNamespaceName());
        dto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getNamespaceId()));
        dto.setRegistrationType(NamespaceRegistrationTypeEnum.fromValue((Integer)transaction.getNamespaceRegistrationType().getValue()));
        dto.setDuration((BigInteger)transaction.getDuration().orElse(null));
        dto.setParentId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getParentId().orElse(null)));
    }
}

