/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.blockchain.BlockDuration;
import io.nem.symbol.sdk.model.mosaic.MosaicFlags;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicNonce;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MosaicDefinitionTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicDefinitionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicDefinitionTransactionDTO;
import java.math.BigInteger;

class MosaicDefinitionTransactionMapper
extends AbstractTransactionMapper<MosaicDefinitionTransactionDTO, MosaicDefinitionTransaction> {
    public MosaicDefinitionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_DEFINITION, MosaicDefinitionTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicDefinitionTransaction> createFactory(NetworkType networkType, MosaicDefinitionTransactionDTO transaction) {
        MosaicFlags mosaicFlags = MosaicFlags.create((int)transaction.getFlags());
        return MosaicDefinitionTransactionFactory.create((NetworkType)networkType, (MosaicNonce)MosaicNonce.createFromInteger((Integer)transaction.getNonce().intValue()), (MosaicId)MapperUtils.toMosaicId((String)transaction.getId()), (MosaicFlags)mosaicFlags, (int)transaction.getDivisibility(), (BlockDuration)new BlockDuration(transaction.getDuration()));
    }

    @Override
    protected void copyToDto(MosaicDefinitionTransaction transaction, MosaicDefinitionTransactionDTO dto) {
        dto.setFlags(Integer.valueOf(transaction.getMosaicFlags().getValue()));
        dto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setDivisibility(Integer.valueOf(transaction.getDivisibility()));
        dto.setNonce(Long.valueOf(transaction.getMosaicNonce().getNonceAsLong()));
        dto.setDuration(BigInteger.valueOf(transaction.getBlockDuration().getDuration()));
    }
}

