/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.AccountKeyLinkTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountKeyLinkTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;

class AccountKeyLinkTransactionMapper
extends AbstractTransactionMapper<AccountKeyLinkTransactionDTO, AccountKeyLinkTransaction> {
    public AccountKeyLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_KEY_LINK, AccountKeyLinkTransactionDTO.class);
    }

    protected AccountKeyLinkTransactionFactory createFactory(NetworkType networkType, AccountKeyLinkTransactionDTO dto) {
        PublicAccount remoteAccount = PublicAccount.createFromPublicKey((String)dto.getRemotePublicKey(), (NetworkType)networkType);
        return AccountKeyLinkTransactionFactory.create((NetworkType)networkType, (PublicAccount)remoteAccount, (LinkAction)LinkAction.rawValueOf((int)dto.getLinkAction().getValue()));
    }

    @Override
    protected void copyToDto(AccountKeyLinkTransaction transaction, AccountKeyLinkTransactionDTO dto) {
        dto.setRemotePublicKey(transaction.getRemoteAccount().getPublicKey().toHex());
        dto.setLinkAction(LinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
    }
}

