/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.ReceiptRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.ReceiptMappingVertx;
import io.nem.symbol.sdk.model.blockchain.MerklePathItem;
import io.nem.symbol.sdk.model.blockchain.MerkleProofInfo;
import io.nem.symbol.sdk.model.blockchain.Position;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.receipt.Statement;
import io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.StatementsDTO;
import io.reactivex.Observable;
import io.vertx.core.Handler;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ReceiptRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements ReceiptRepository {
    private final ReceiptRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public ReceiptRepositoryVertxImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new ReceiptRoutesApiImpl(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public Observable<Statement> getBlockReceipts(BigInteger height) {
        Consumer<Handler> callback = handler -> this.getClient().getBlockReceipts(height, handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(statementsDTO -> new ReceiptMappingVertx(this.getJsonHelper()).createStatementFromDto((StatementsDTO)statementsDTO, (NetworkType)networkType))));
    }

    public Observable<MerkleProofInfo> getMerkleReceipts(BigInteger height, String hash) {
        Consumer callback = handler -> this.getClient().getMerkleReceipts(height, hash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toMerkleProofInfo));
    }

    private MerkleProofInfo toMerkleProofInfo(MerkleProofInfoDTO dto) {
        List pathItems = dto.getMerklePath().stream().map(pathItem -> new MerklePathItem(pathItem.getPosition() == null ? null : Position.rawValueOf((String)pathItem.getPosition().getValue()), pathItem.getHash())).collect(Collectors.toList());
        return new MerkleProofInfo(pathItems);
    }

    public ReceiptRoutesApi getClient() {
        return this.client;
    }
}

