/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.NetworkRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.network.AccountLinkNetworkProperties;
import io.nem.symbol.sdk.model.network.AccountRestrictionNetworkProperties;
import io.nem.symbol.sdk.model.network.AggregateNetworkProperties;
import io.nem.symbol.sdk.model.network.ChainProperties;
import io.nem.symbol.sdk.model.network.HashLockNetworkProperties;
import io.nem.symbol.sdk.model.network.MetadataNetworkProperties;
import io.nem.symbol.sdk.model.network.MosaicNetworkProperties;
import io.nem.symbol.sdk.model.network.MosaicRestrictionNetworkProperties;
import io.nem.symbol.sdk.model.network.MultisigNetworkProperties;
import io.nem.symbol.sdk.model.network.NamespaceNetworkProperties;
import io.nem.symbol.sdk.model.network.NetworkConfiguration;
import io.nem.symbol.sdk.model.network.NetworkInfo;
import io.nem.symbol.sdk.model.network.NetworkProperties;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.network.NodeIdentityEqualityStrategy;
import io.nem.symbol.sdk.model.network.PluginsProperties;
import io.nem.symbol.sdk.model.network.RentalFees;
import io.nem.symbol.sdk.model.network.SecretLockNetworkProperties;
import io.nem.symbol.sdk.model.network.TransactionFees;
import io.nem.symbol.sdk.model.network.TransferNetworkProperties;
import io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountKeyLinkNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AggregateNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ChainPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicRestrictionNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.PluginsPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockNetworkPropertiesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransferNetworkPropertiesDTO;
import io.reactivex.Observable;
import java.util.function.Consumer;

public class NetworkRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NetworkRepository {
    private final NetworkRoutesApi networkRoutesApi;
    private final NodeRoutesApi nodeRoutesApi;

    public NetworkRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.networkRoutesApi = new NetworkRoutesApiImpl(apiClient);
        this.nodeRoutesApi = new NodeRoutesApiImpl(apiClient);
    }

    public Observable<NetworkType> getNetworkType() {
        Consumer callback = handler -> this.getNodeRoutesApi().getNodeInfo(handler);
        return this.exceptionHandling(this.call(callback).map(info -> NetworkType.rawValueOf((int)info.getNetworkIdentifier())));
    }

    public Observable<TransactionFees> getTransactionFees() {
        Consumer callback = handler -> this.getNetworkRoutesApi().getTransactionFees(handler);
        return this.exceptionHandling(this.call(callback).map(info -> new TransactionFees(info.getAverageFeeMultiplier(), info.getMedianFeeMultiplier(), info.getLowestFeeMultiplier(), info.getHighestFeeMultiplier())));
    }

    public Observable<RentalFees> getRentalFees() {
        Consumer callback = handler -> this.getNetworkRoutesApi().getRentalFees(handler);
        return this.exceptionHandling(this.call(callback).map(info -> new RentalFees(info.getEffectiveRootNamespaceRentalFeePerBlock(), info.getEffectiveChildNamespaceRentalFee(), info.getEffectiveMosaicRentalFee())));
    }

    public Observable<NetworkInfo> getNetworkInfo() {
        Consumer callback = handler -> this.getNetworkRoutesApi().getNetworkType(handler);
        return this.exceptionHandling(this.call(callback).map(info -> new NetworkInfo(info.getName(), info.getDescription())));
    }

    public Observable<NetworkConfiguration> getNetworkProperties() {
        return this.call(arg_0 -> ((NetworkRoutesApi)this.getNetworkRoutesApi()).getNetworkProperties(arg_0)).map(info -> new NetworkConfiguration(this.toNetworkProperties(info.getNetwork()), this.toChainProperties(info.getChain()), this.toPluginsProperties(info.getPlugins())));
    }

    private NetworkProperties toNetworkProperties(NetworkPropertiesDTO dto) {
        return new NetworkProperties(dto.getIdentifier(), NodeIdentityEqualityStrategy.rawValueOf((String)dto.getNodeEqualityStrategy().getValue()), dto.getPublicKey(), dto.getGenerationHashSeed(), dto.getEpochAdjustment());
    }

    private ChainProperties toChainProperties(ChainPropertiesDTO dto) {
        return new ChainProperties(dto.getEnableVerifiableState(), dto.getEnableVerifiableReceipts(), dto.getCurrencyMosaicId(), dto.getHarvestingMosaicId(), dto.getBlockGenerationTargetTime(), dto.getBlockTimeSmoothingFactor(), dto.getBlockFinalizationInterval(), dto.getImportanceGrouping(), dto.getImportanceActivityPercentage(), dto.getMaxRollbackBlocks(), dto.getMaxDifficultyBlocks(), dto.getDefaultDynamicFeeMultiplier(), dto.getMaxTransactionLifetime(), dto.getMaxBlockFutureTime(), dto.getInitialCurrencyAtomicUnits(), dto.getMaxMosaicAtomicUnits(), dto.getTotalChainImportance(), dto.getMinHarvesterBalance(), dto.getMaxHarvesterBalance(), dto.getMinVoterBalance(), dto.getHarvestBeneficiaryPercentage(), dto.getHarvestNetworkPercentage(), dto.getHarvestNetworkFeeSinkPublicKey(), dto.getBlockPruneInterval(), dto.getMaxTransactionsPerBlock());
    }

    private PluginsProperties toPluginsProperties(PluginsPropertiesDTO dto) {
        return new PluginsProperties(this.toAccountlink(dto.getAccountlink()), this.toAggregate(dto.getAggregate()), this.toLockhash(dto.getLockhash()), this.toLocksecret(dto.getLocksecret()), this.toMetadata(dto.getMetadata()), this.toMosaic(dto.getMosaic()), this.toMultisig(dto.getMultisig()), this.toNamespace(dto.getNamespace()), this.toRestrictionaccount(dto.getRestrictionaccount()), this.toRestrictionmosaic(dto.getRestrictionmosaic()), this.toTransfer(dto.getTransfer()));
    }

    private AccountLinkNetworkProperties toAccountlink(AccountKeyLinkNetworkPropertiesDTO dto) {
        return new AccountLinkNetworkProperties(dto.getDummy());
    }

    private AggregateNetworkProperties toAggregate(AggregateNetworkPropertiesDTO dto) {
        return new AggregateNetworkProperties(dto.getMaxTransactionsPerAggregate(), dto.getMaxCosignaturesPerAggregate(), dto.getEnableStrictCosignatureCheck(), dto.getEnableBondedAggregateSupport(), dto.getMaxBondedTransactionLifetime());
    }

    private HashLockNetworkProperties toLockhash(HashLockNetworkPropertiesDTO dto) {
        return new HashLockNetworkProperties(dto.getLockedFundsPerAggregate(), dto.getMaxHashLockDuration());
    }

    private SecretLockNetworkProperties toLocksecret(SecretLockNetworkPropertiesDTO dto) {
        return new SecretLockNetworkProperties(dto.getMaxSecretLockDuration(), dto.getMinProofSize(), dto.getMaxProofSize());
    }

    private MetadataNetworkProperties toMetadata(MetadataNetworkPropertiesDTO dto) {
        return new MetadataNetworkProperties(dto.getMaxValueSize());
    }

    private MosaicNetworkProperties toMosaic(MosaicNetworkPropertiesDTO dto) {
        return new MosaicNetworkProperties(dto.getMaxMosaicsPerAccount(), dto.getMaxMosaicDuration(), dto.getMaxMosaicDivisibility(), dto.getMosaicRentalFeeSinkPublicKey(), dto.getMosaicRentalFee());
    }

    private MultisigNetworkProperties toMultisig(MultisigNetworkPropertiesDTO dto) {
        return new MultisigNetworkProperties(dto.getMaxMultisigDepth(), dto.getMaxCosignatoriesPerAccount(), dto.getMaxCosignedAccountsPerAccount());
    }

    private NamespaceNetworkProperties toNamespace(NamespaceNetworkPropertiesDTO dto) {
        return new NamespaceNetworkProperties(dto.getMaxNameSize(), dto.getMaxChildNamespaces(), dto.getMaxNamespaceDepth(), dto.getMinNamespaceDuration(), dto.getMaxNamespaceDuration(), dto.getNamespaceGracePeriodDuration(), dto.getReservedRootNamespaceNames(), dto.getNamespaceRentalFeeSinkPublicKey(), dto.getRootNamespaceRentalFeePerBlock(), dto.getChildNamespaceRentalFee());
    }

    private AccountRestrictionNetworkProperties toRestrictionaccount(AccountRestrictionNetworkPropertiesDTO dto) {
        return new AccountRestrictionNetworkProperties(dto.getMaxAccountRestrictionValues());
    }

    private MosaicRestrictionNetworkProperties toRestrictionmosaic(MosaicRestrictionNetworkPropertiesDTO dto) {
        return new MosaicRestrictionNetworkProperties(dto.getMaxMosaicRestrictionValues());
    }

    private TransferNetworkProperties toTransfer(TransferNetworkPropertiesDTO dto) {
        return new TransferNetworkProperties(dto.getMaxMessageSize());
    }

    public NetworkRoutesApi getNetworkRoutesApi() {
        return this.networkRoutesApi;
    }

    public NodeRoutesApi getNodeRoutesApi() {
        return this.nodeRoutesApi;
    }
}

