/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.api.QueryParams;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.AccountNames;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicNames;
import io.nem.symbol.sdk.model.namespace.AddressAlias;
import io.nem.symbol.sdk.model.namespace.Alias;
import io.nem.symbol.sdk.model.namespace.AliasType;
import io.nem.symbol.sdk.model.namespace.EmptyAlias;
import io.nem.symbol.sdk.model.namespace.MosaicAlias;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceInfo;
import io.nem.symbol.sdk.model.namespace.NamespaceName;
import io.nem.symbol.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacesInfoDTO;
import io.reactivex.Observable;
import io.vertx.core.Handler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class NamespaceRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NamespaceRepository {
    private final NamespaceRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public NamespaceRepositoryVertxImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new NamespaceRoutesApiImpl(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public NamespaceRoutesApi getClient() {
        return this.client;
    }

    public Observable<NamespaceInfo> getNamespace(NamespaceId namespaceId) {
        Consumer<Handler> callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(namespaceInfoDTO -> this.toNamespaceInfo((NamespaceInfoDTO)namespaceInfoDTO, (NetworkType)networkType))));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address, QueryParams queryParams) {
        return this.getNamespacesFromAccount(address, Optional.of(queryParams));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address) {
        return this.getNamespacesFromAccount(address, Optional.empty());
    }

    private Observable<List<NamespaceInfo>> getNamespacesFromAccount(Address address, Optional<QueryParams> queryParams) {
        Consumer<Handler> callback = handler -> this.client.getNamespacesFromAccount(address.plain(), this.getPageSize(queryParams), this.getId(queryParams), handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).flatMapIterable(NamespacesInfoDTO::getNamespaces).map(namespaceInfoDTO -> this.toNamespaceInfo((NamespaceInfoDTO)namespaceInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<NamespaceInfo>> getNamespacesFromAccounts(List<Address> addresses) {
        AccountIds accounts = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Consumer<Handler> callback = handler -> this.client.getNamespacesFromAccounts(accounts, handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).flatMapIterable(NamespacesInfoDTO::getNamespaces).map(namespaceInfoDTO -> this.toNamespaceInfo((NamespaceInfoDTO)namespaceInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<NamespaceName>> getNamespaceNames(List<NamespaceId> namespaceIds) {
        NamespaceIds ids = new NamespaceIds().namespaceIds(namespaceIds.stream().map(NamespaceId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.client.getNamespacesNames(ids, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toNamespaceName).toList().toObservable());
    }

    public Observable<List<MosaicNames>> getMosaicsNames(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getMosaicsNames(mosaicIds, handler);
        return this.exceptionHandling(this.call(callback).map(MosaicsNamesDTO::getMosaicNames).flatMapIterable(item -> item).map(this::toMosaicNames).toList().toObservable());
    }

    private MosaicNames toMosaicNames(MosaicNamesDTO dto) {
        return new MosaicNames(MapperUtils.toMosaicId((String)dto.getMosaicId()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    public Observable<MosaicId> getLinkedMosaicId(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toMosaicId(namespaceInfoDTO.getNamespace())));
    }

    public Observable<Address> getLinkedAddress(NamespaceId namespaceId) {
        Consumer callback = handler -> this.getClient().getNamespace(namespaceId.getIdAsHex(), handler);
        return this.exceptionHandling(this.call(callback).map(namespaceInfoDTO -> this.toAddress(namespaceInfoDTO.getNamespace())));
    }

    private NamespaceName toNamespaceName(NamespaceNameDTO dto) {
        return new NamespaceName(MapperUtils.toNamespaceId((String)dto.getId()), dto.getName(), Optional.ofNullable(MapperUtils.toNamespaceId((String)dto.getParentId())));
    }

    private NamespaceInfo toNamespaceInfo(NamespaceInfoDTO namespaceInfoDTO, NetworkType networkType) {
        return new NamespaceInfo(namespaceInfoDTO.getMeta().getActive().booleanValue(), namespaceInfoDTO.getMeta().getIndex(), namespaceInfoDTO.getMeta().getId(), NamespaceRegistrationType.rawValueOf((int)namespaceInfoDTO.getNamespace().getRegistrationType().getValue()), namespaceInfoDTO.getNamespace().getDepth(), this.extractLevels(namespaceInfoDTO), MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getParentId()), new PublicAccount(namespaceInfoDTO.getNamespace().getOwnerPublicKey(), networkType), namespaceInfoDTO.getNamespace().getStartHeight(), namespaceInfoDTO.getNamespace().getEndHeight(), this.extractAlias(namespaceInfoDTO.getNamespace()));
    }

    private MosaicId toMosaicId(NamespaceDTO namespaceDTO) {
        MosaicId mosaicId = null;
        if (namespaceDTO.getAlias() != null && AliasType.MOSAIC.getValue().equals(namespaceDTO.getAlias().getType().getValue())) {
            mosaicId = MapperUtils.toMosaicId((String)namespaceDTO.getAlias().getMosaicId());
        }
        return mosaicId;
    }

    private Address toAddress(NamespaceDTO namespaceDTO) {
        String encodedAddress;
        Address address = null;
        if (namespaceDTO.getAlias() != null && AliasType.ADDRESS.getValue().equals(namespaceDTO.getAlias().getType().getValue()) && (encodedAddress = namespaceDTO.getAlias().getAddress()) != null) {
            address = MapperUtils.toAddressFromEncoded((String)encodedAddress);
        }
        return address;
    }

    public Observable<List<AccountNames>> getAccountsNames(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        return this.getAccountsNames(accountIds);
    }

    private Observable<List<AccountNames>> getAccountsNames(AccountIds accountIds) {
        Consumer callback = handler -> this.getClient().getAccountsNames(accountIds, handler);
        return this.exceptionHandling(this.call(callback).map(AccountsNamesDTO::getAccountNames).flatMapIterable(item -> item).map(this::toAccountNames).toList().toObservable());
    }

    private AccountNames toAccountNames(AccountNamesDTO dto) {
        return new AccountNames(MapperUtils.toAddressFromEncoded((String)dto.getAddress()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    private List<NamespaceId> extractLevels(NamespaceInfoDTO namespaceInfoDTO) {
        ArrayList<NamespaceId> levels = new ArrayList<NamespaceId>();
        if (namespaceInfoDTO.getNamespace().getLevel0() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel0()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel1() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel1()));
        }
        if (namespaceInfoDTO.getNamespace().getLevel2() != null) {
            levels.add(MapperUtils.toNamespaceId((String)namespaceInfoDTO.getNamespace().getLevel2()));
        }
        return levels;
    }

    private Alias extractAlias(NamespaceDTO namespaceDTO) {
        EmptyAlias alias = new EmptyAlias();
        if (namespaceDTO.getAlias() != null) {
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.MOSAIC.getValue())) {
                return new MosaicAlias(this.toMosaicId(namespaceDTO));
            }
            if (namespaceDTO.getAlias().getType().getValue().equals(AliasType.ADDRESS.getValue())) {
                return new AddressAlias(this.toAddress(namespaceDTO));
            }
        }
        return alias;
    }
}

