/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.AccountRepository;
import io.nem.symbol.sdk.api.TransactionSearchCriteria;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.TransactionMapper;
import io.nem.symbol.sdk.model.account.AccountInfo;
import io.nem.symbol.sdk.model.account.AccountKey;
import io.nem.symbol.sdk.model.account.AccountType;
import io.nem.symbol.sdk.model.account.ActivityBucket;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.KeyType;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;
import io.reactivex.Observable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AccountRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements AccountRepository {
    private final AccountRoutesApi client;
    private final TransactionMapper transactionMapper;

    public AccountRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new AccountRoutesApiImpl(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public Observable<AccountInfo> getAccountInfo(Address address) {
        Consumer callback = handler -> this.getClient().getAccountInfo(address.plain(), handler);
        return this.exceptionHandling(this.call(callback).map(AccountInfoDTO::getAccount).map(this::toAccountInfo));
    }

    public Observable<List<AccountInfo>> getAccountsInfo(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Consumer callback = handler -> this.getClient().getAccountsInfo(accountIds, handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(AccountInfoDTO::getAccount).map(this::toAccountInfo).toList().toObservable());
    }

    public Observable<List<Transaction>> transactions(PublicAccount publicAccount) {
        return this.transactions(publicAccount, new TransactionSearchCriteria());
    }

    public Observable<List<Transaction>> transactions(PublicAccount publicAccount, TransactionSearchCriteria criteria) {
        Consumer callback = handler -> this.client.getAccountConfirmedTransactions(publicAccount.getPublicKey().toHex(), criteria.getPageSize(), criteria.getId(), criteria.getOrder(), this.toTransactionTypes(criteria.getTransactionTypes()), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount) {
        return this.incomingTransactions(publicAccount, new TransactionSearchCriteria());
    }

    public Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount, TransactionSearchCriteria criteria) {
        Consumer callback = handler -> this.client.getAccountIncomingTransactions(publicAccount.getPublicKey().toHex(), criteria.getPageSize(), criteria.getId(), criteria.getOrder(), this.toTransactionTypes(criteria.getTransactionTypes()), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount) {
        return this.outgoingTransactions(publicAccount, new TransactionSearchCriteria());
    }

    public Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount, TransactionSearchCriteria criteria) {
        Consumer callback = handler -> this.client.getAccountOutgoingTransactions(publicAccount.getPublicKey().toHex(), criteria.getPageSize(), criteria.getId(), criteria.getOrder(), this.toTransactionTypes(criteria.getTransactionTypes()), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> partialTransactions(PublicAccount publicAccount) {
        return this.partialTransactions(publicAccount, new TransactionSearchCriteria());
    }

    public Observable<List<Transaction>> partialTransactions(PublicAccount publicAccount, TransactionSearchCriteria criteria) {
        Consumer callback = handler -> this.client.getAccountPartialTransactions(publicAccount.getPublicKey().toHex(), criteria.getPageSize(), criteria.getId(), criteria.getOrder(), this.toTransactionTypes(criteria.getTransactionTypes()), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private Transaction toTransaction(TransactionInfoDTO input) {
        return this.transactionMapper.map(input);
    }

    public Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount) {
        return this.aggregateBondedTransactions(publicAccount, new TransactionSearchCriteria());
    }

    public Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount, TransactionSearchCriteria criteria) {
        Consumer callback = handler -> this.client.getAccountPartialTransactions(publicAccount.getPublicKey().toHex(), criteria.getPageSize(), criteria.getId(), criteria.getOrder(), this.toTransactionTypes(criteria.getTransactionTypes()), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).map(o -> (AggregateTransaction)o).toList().toObservable());
    }

    public Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount) {
        return this.unconfirmedTransactions(publicAccount, new TransactionSearchCriteria());
    }

    public Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount, TransactionSearchCriteria criteria) {
        Consumer callback = handler -> this.client.getAccountUnconfirmedTransactions(publicAccount.getPublicKey().toHex(), criteria.getPageSize(), criteria.getId(), criteria.getOrder(), this.toTransactionTypes(criteria.getTransactionTypes()), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private AccountInfo toAccountInfo(AccountDTO accountDTO) {
        return new AccountInfo(MapperUtils.toAddressFromEncoded((String)accountDTO.getAddress()), accountDTO.getAddressHeight(), accountDTO.getPublicKey(), accountDTO.getPublicKeyHeight(), accountDTO.getImportance(), accountDTO.getImportanceHeight(), accountDTO.getMosaics().stream().map(mosaicDTO -> new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)mosaicDTO.getId()), mosaicDTO.getAmount())).collect(Collectors.toList()), AccountType.rawValueOf((int)accountDTO.getAccountType().getValue()), accountDTO.getSupplementalAccountKeys().stream().map(dto -> new AccountKey(KeyType.rawValueOf((int)dto.getKeyType().getValue()), dto.getKey())).collect(Collectors.toList()), accountDTO.getActivityBuckets().stream().map(dto -> new ActivityBucket(dto.getStartHeight(), dto.getTotalFeesPaid(), dto.getBeneficiaryCount().intValue(), dto.getRawScore())).collect(Collectors.toList()));
    }

    private AccountRoutesApi getClient() {
        return this.client;
    }

    private List<TransactionTypeEnum> toTransactionTypes(List<TransactionType> transactionTypes) {
        return transactionTypes == null || transactionTypes.isEmpty() ? null : transactionTypes.stream().map(transactionType -> TransactionTypeEnum.fromValue((Integer)transactionType.getValue())).collect(Collectors.toList());
    }
}

