/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LockHashAlgorithmType;
import io.nem.symbol.sdk.model.transaction.SecretProofTransaction;
import io.nem.symbol.sdk.model.transaction.SecretProofTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.vertx.model.SecretProofTransactionDTO;

class SecretProofTransactionMapper
extends AbstractTransactionMapper<SecretProofTransactionDTO, SecretProofTransaction> {
    public SecretProofTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.SECRET_PROOF, SecretProofTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<SecretProofTransaction> createFactory(NetworkType networkType, SecretProofTransactionDTO transaction) {
        return SecretProofTransactionFactory.create((NetworkType)networkType, (LockHashAlgorithmType)LockHashAlgorithmType.rawValueOf((int)transaction.getHashAlgorithm().getValue()), (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()), (String)transaction.getSecret(), (String)transaction.getProof());
    }

    @Override
    protected void copyToDto(SecretProofTransaction transaction, SecretProofTransactionDTO dto) {
        dto.setHashAlgorithm(LockHashAlgorithmEnum.fromValue((Integer)transaction.getHashType().getValue()));
        dto.setRecipientAddress(transaction.getRecipient().encoded(transaction.getNetworkType()));
        dto.setSecret(transaction.getSecret());
        dto.setProof(transaction.getProof());
    }
}

