/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.AccountMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountMetadataTransactionDTO;
import java.math.BigInteger;

class AccountMetadataTransactionMapper
extends AbstractTransactionMapper<AccountMetadataTransactionDTO, AccountMetadataTransaction> {
    public AccountMetadataTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_METADATA, AccountMetadataTransactionDTO.class);
    }

    protected AccountMetadataTransactionFactory createFactory(NetworkType networkType, AccountMetadataTransactionDTO transaction) {
        PublicAccount targetAccount = PublicAccount.createFromPublicKey((String)transaction.getTargetPublicKey(), (NetworkType)networkType);
        Integer valueSizeDelta = transaction.getValueSizeDelta();
        BigInteger scopedMetaDataKey = new BigInteger(transaction.getScopedMetadataKey(), 16);
        String value = ConvertUtils.fromHexToString((String)transaction.getValue());
        AccountMetadataTransactionFactory factory = AccountMetadataTransactionFactory.create((NetworkType)networkType, (PublicAccount)targetAccount, (BigInteger)scopedMetaDataKey, (String)value);
        factory.valueSizeDelta(valueSizeDelta.intValue());
        Integer valueSize = transaction.getValueSize();
        if (valueSize != null) {
            factory.valueSize(valueSize.intValue());
        }
        return factory;
    }

    @Override
    protected void copyToDto(AccountMetadataTransaction transaction, AccountMetadataTransactionDTO dto) {
        dto.setTargetPublicKey(transaction.getTargetAccount().getPublicKey().toHex());
        dto.setValueSizeDelta(Integer.valueOf(transaction.getValueSizeDelta()));
        dto.setScopedMetadataKey(transaction.getScopedMetadataKey().toString(16));
        dto.setValue(ConvertUtils.fromStringToHex((String)transaction.getValue()));
        dto.setValueSize(Integer.valueOf(transaction.getValueSize()));
    }
}

