/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountLinkAction;
import io.nem.symbol.sdk.model.transaction.AccountLinkTransaction;
import io.nem.symbol.sdk.model.transaction.AccountLinkTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AccountLinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.AccountLinkTransactionDTO;

class AccountLinkTransactionMapper
extends AbstractTransactionMapper<AccountLinkTransactionDTO, AccountLinkTransaction> {
    public AccountLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_LINK, AccountLinkTransactionDTO.class);
    }

    protected AccountLinkTransactionFactory createFactory(NetworkType networkType, AccountLinkTransactionDTO dto) {
        PublicAccount remoteAccount = PublicAccount.createFromPublicKey((String)dto.getRemotePublicKey(), (NetworkType)networkType);
        return AccountLinkTransactionFactory.create((NetworkType)networkType, (PublicAccount)remoteAccount, (AccountLinkAction)AccountLinkAction.rawValueOf((int)dto.getLinkAction().getValue()));
    }

    @Override
    protected void copyToDto(AccountLinkTransaction transaction, AccountLinkTransactionDTO dto) {
        dto.setRemotePublicKey(transaction.getRemoteAccount().getPublicKey().toHex());
        dto.setLinkAction(AccountLinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
    }
}

