/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.TransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionInfo;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionMetaDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionMetaDTO;
import java.math.BigInteger;

public abstract class AbstractTransactionMapper<D, T extends Transaction>
implements TransactionMapper {
    private final TransactionType transactionType;
    private final JsonHelper jsonHelper;
    private Class<D> transactionDtoClass;

    public AbstractTransactionMapper(JsonHelper jsonHelper, TransactionType transactionType, Class<D> transactionDtoClass) {
        this.jsonHelper = jsonHelper;
        this.transactionType = transactionType;
        this.transactionDtoClass = transactionDtoClass;
    }

    @Override
    public Transaction map(EmbeddedTransactionInfoDTO transactionInfoDTO) {
        TransactionInfo transactionInfo = this.createTransactionInfo(transactionInfoDTO.getMeta());
        return this.createModel(transactionInfo, transactionInfoDTO.getTransaction());
    }

    @Override
    public Transaction map(TransactionInfoDTO transactionInfoDTO) {
        TransactionInfo transactionInfo = this.createTransactionInfo(transactionInfoDTO.getMeta());
        return this.createModel(transactionInfo, transactionInfoDTO.getTransaction());
    }

    protected final T createModel(TransactionInfo transactionInfo, Object transactionDto) {
        Transaction transactionModel;
        Object transaction = this.getJsonHelper().convert(transactionDto, this.transactionDtoClass);
        TransactionDTO transactionDTO = (TransactionDTO)this.getJsonHelper().convert(transactionDto, TransactionDTO.class);
        NetworkType networkType = NetworkType.rawValueOf((int)transactionDTO.getNetwork().getValue());
        TransactionFactory<T> factory = this.createFactory(networkType, transaction);
        factory.version(transactionDTO.getVersion());
        if (transactionDTO.getDeadline() != null) {
            factory.deadline(new Deadline(transactionDTO.getDeadline()));
        }
        if (transactionDTO.getSignerPublicKey() != null) {
            factory.signer(PublicAccount.createFromPublicKey((String)transactionDTO.getSignerPublicKey(), (NetworkType)networkType));
        }
        if (transactionDTO.getSignature() != null) {
            factory.signature(transactionDTO.getSignature());
        }
        if (transactionDTO.getMaxFee() != null) {
            factory.maxFee(transactionDTO.getMaxFee());
        }
        if (transactionInfo != null) {
            factory.transactionInfo(transactionInfo);
        }
        if ((transactionModel = factory.build()).getType() != this.getTransactionType()) {
            throw new IllegalStateException("Expected transaction to be " + this.getTransactionType() + " but got " + transactionModel.getType());
        }
        return (T)transactionModel;
    }

    protected abstract TransactionFactory<T> createFactory(NetworkType var1, D var2);

    protected TransactionInfo createTransactionInfo(TransactionMetaDTO meta) {
        return meta == null ? null : TransactionInfo.create((BigInteger)meta.getHeight(), (Integer)meta.getIndex(), (String)meta.getId(), (String)meta.getHash(), (String)meta.getMerkleComponentHash());
    }

    protected TransactionInfo createTransactionInfo(EmbeddedTransactionMetaDTO meta) {
        return meta == null ? null : TransactionInfo.createAggregate((BigInteger)meta.getHeight(), (Integer)meta.getIndex(), (String)meta.getId(), (String)meta.getAggregateHash(), (String)meta.getAggregateId());
    }

    @Override
    public EmbeddedTransactionInfoDTO mapToEmbedded(Transaction transaction) {
        EmbeddedTransactionInfoDTO dto = new EmbeddedTransactionInfoDTO();
        dto.setMeta(this.createTransactionInfoEmbedded(transaction));
        dto.setTransaction(this.mapTransaction(transaction, true));
        return dto;
    }

    private EmbeddedTransactionMetaDTO createTransactionInfoEmbedded(Transaction transaction) {
        return transaction.getTransactionInfo().map((? super T i) -> {
            EmbeddedTransactionMetaDTO dto = new EmbeddedTransactionMetaDTO();
            dto.setHeight(i.getHeight());
            dto.setAggregateHash((String)i.getAggregateHash().orElse(null));
            dto.setId((String)i.getId().orElse(null));
            dto.setIndex((Integer)i.getIndex().orElse(null));
            dto.setAggregateId((String)i.getAggregateId().orElse(null));
            return dto;
        }).orElse(null);
    }

    private TransactionMetaDTO createTransactionInfo(Transaction transaction) {
        return transaction.getTransactionInfo().map((? super T i) -> {
            TransactionMetaDTO dto = new TransactionMetaDTO();
            dto.setHeight(i.getHeight());
            dto.setHash((String)i.getHash().orElse(null));
            dto.setId((String)i.getId().orElse(null));
            dto.setIndex((Integer)i.getIndex().orElse(null));
            dto.setMerkleComponentHash((String)i.getMerkleComponentHash().orElse(null));
            return dto;
        }).orElse(null);
    }

    @Override
    public TransactionInfoDTO map(Transaction transaction) {
        TransactionInfoDTO dto = new TransactionInfoDTO();
        dto.setMeta(this.createTransactionInfo(transaction));
        dto.setTransaction(this.mapTransaction(transaction, false));
        return dto;
    }

    private D mapTransaction(Transaction transaction, boolean embedded) {
        TransactionDTO dto = new TransactionDTO();
        dto.setSignerPublicKey((String)transaction.getSigner().map(PublicAccount::getPublicKey).map(PublicKey::toHex).orElse(null));
        dto.setVersion(transaction.getVersion());
        dto.setType(Integer.valueOf(transaction.getType().getValue()));
        dto.setNetwork(NetworkTypeEnum.fromValue((Integer)transaction.getNetworkType().getValue()));
        if (!embedded) {
            dto.setMaxFee(transaction.getMaxFee());
            dto.setDeadline(transaction.getDeadline().toBigInteger());
            dto.setSignature((String)transaction.getSignature().orElse(null));
        }
        Object specificDto = this.getJsonHelper().parse(this.getJsonHelper().print((Object)dto), this.transactionDtoClass);
        this.copyToDto(transaction, specificDto);
        return (D)specificDto;
    }

    protected abstract void copyToDto(T var1, D var2);

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    @Override
    public TransactionType getTransactionType() {
        return this.transactionType;
    }
}

