/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.nem.symbol.sdk.api.JsonSerialization;
import io.nem.symbol.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import org.apache.commons.lang3.Validate;

public class JsonSerializationVertx
implements JsonSerialization {
    private final GeneralTransactionMapper generalTransactionMapper;
    private final JsonHelper jsonHelper;

    public JsonSerializationVertx(ObjectMapper objectMapper) {
        Validate.notNull((Object)objectMapper, (String)"ObjectMapper must not be null", (Object[])new Object[0]);
        this.jsonHelper = new JsonHelperJackson2(objectMapper);
        this.generalTransactionMapper = new GeneralTransactionMapper(this.jsonHelper);
    }

    public String transactionToJson(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"Transaction must not be null", (Object[])new Object[0]);
        return this.jsonHelper.print((Object)this.generalTransactionMapper.map(transaction));
    }

    public Transaction jsonToTransaction(String json) {
        Validate.notNull((Object)json, (String)"Json must not be null", (Object[])new Object[0]);
        return this.generalTransactionMapper.map((TransactionInfoDTO)this.jsonHelper.parse(json, TransactionInfoDTO.class));
    }
}

