/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.ChainRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.BlockchainScore;
import io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.HeightInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.function.Consumer;

public class ChainRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements ChainRepository {
    private final ChainRoutesApi client;

    public ChainRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new ChainRoutesApiImpl(apiClient);
    }

    public ChainRoutesApi getClient() {
        return this.client;
    }

    public Observable<BigInteger> getBlockchainHeight() {
        Consumer callback = arg_0 -> ((ChainRoutesApi)this.client).getChainHeight(arg_0);
        return this.exceptionHandling(this.call(callback).map(HeightInfoDTO::getHeight));
    }

    public Observable<BlockchainScore> getChainScore() {
        Consumer callback = arg_0 -> ((ChainRoutesApi)this.client).getChainScore(arg_0);
        return this.exceptionHandling(this.call(callback).map(blockchainScoreDTO -> new BlockchainScore(blockchainScoreDTO.getScoreLow(), blockchainScoreDTO.getScoreHigh())));
    }
}

