/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.LockHashAlgorithmType;
import io.nem.symbol.sdk.model.transaction.SecretLockTransaction;
import io.nem.symbol.sdk.model.transaction.SecretLockTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockTransactionDTO;
import java.math.BigInteger;

class SecretLockTransactionMapper
extends AbstractTransactionMapper<SecretLockTransactionDTO, SecretLockTransaction> {
    public SecretLockTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.SECRET_LOCK, SecretLockTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<SecretLockTransaction> createFactory(NetworkType networkType, SecretLockTransactionDTO transaction) {
        Mosaic mosaic = new Mosaic(MapperUtils.toUnresolvedMosaicId((String)transaction.getMosaicId()), transaction.getAmount());
        return SecretLockTransactionFactory.create((NetworkType)networkType, (Mosaic)mosaic, (BigInteger)transaction.getDuration(), (LockHashAlgorithmType)LockHashAlgorithmType.rawValueOf((int)transaction.getHashAlgorithm().getValue()), (String)transaction.getSecret(), (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)transaction.getRecipientAddress()));
    }

    @Override
    protected void copyToDto(SecretLockTransaction transaction, SecretLockTransactionDTO dto) {
        dto.setAmount(transaction.getMosaic().getAmount());
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaic().getId()));
        dto.setDuration(transaction.getDuration());
        dto.setHashAlgorithm(LockHashAlgorithmEnum.fromValue((Integer)transaction.getHashAlgorithm().getValue()));
        dto.setSecret(transaction.getSecret());
        dto.setRecipientAddress(transaction.getRecipient().encoded(transaction.getNetworkType()));
    }
}

