/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MultisigAccountModificationTransaction;
import io.nem.symbol.sdk.model.transaction.MultisigAccountModificationTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountModificationTransactionDTO;
import java.util.List;
import java.util.stream.Collectors;

class MultisigAccountModificationTransactionMapper
extends AbstractTransactionMapper<MultisigAccountModificationTransactionDTO, MultisigAccountModificationTransaction> {
    public MultisigAccountModificationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MULTISIG_ACCOUNT_MODIFICATION, MultisigAccountModificationTransactionDTO.class);
    }

    protected MultisigAccountModificationTransactionFactory createFactory(NetworkType networkType, MultisigAccountModificationTransactionDTO transaction) {
        List additions = transaction.getPublicKeyAdditions().stream().map((? super T publicKey) -> PublicAccount.createFromPublicKey((String)publicKey, (NetworkType)networkType)).collect(Collectors.toList());
        List deletions = transaction.getPublicKeyDeletions().stream().map((? super T publicKey) -> PublicAccount.createFromPublicKey((String)publicKey, (NetworkType)networkType)).collect(Collectors.toList());
        return MultisigAccountModificationTransactionFactory.create((NetworkType)networkType, (byte)transaction.getMinApprovalDelta().byteValue(), (byte)transaction.getMinRemovalDelta().byteValue(), additions, deletions);
    }

    @Override
    protected void copyToDto(MultisigAccountModificationTransaction transaction, MultisigAccountModificationTransactionDTO dto) {
        dto.setMinApprovalDelta(Integer.valueOf(transaction.getMinApprovalDelta()));
        dto.setMinRemovalDelta(Integer.valueOf(transaction.getMinRemovalDelta()));
        dto.setPublicKeyAdditions(transaction.getPublicKeyAdditions().stream().map((? super T p) -> p.getPublicKey().toHex()).collect(Collectors.toList()));
        dto.setPublicKeyDeletions(transaction.getPublicKeyDeletions().stream().map((? super T p) -> p.getPublicKey().toHex()).collect(Collectors.toList()));
    }
}

