/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.mosaic.MosaicSupplyChangeActionType;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyChangeTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyChangeTransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicSupplyChangeActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicSupplyChangeTransactionDTO;
import java.math.BigInteger;

class MosaicSupplyChangeTransactionMapper
extends AbstractTransactionMapper<MosaicSupplyChangeTransactionDTO, MosaicSupplyChangeTransaction> {
    public MosaicSupplyChangeTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_SUPPLY_CHANGE, MosaicSupplyChangeTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicSupplyChangeTransaction> createFactory(NetworkType networkType, MosaicSupplyChangeTransactionDTO transaction) {
        return MosaicSupplyChangeTransactionFactory.create((NetworkType)networkType, (UnresolvedMosaicId)MapperUtils.toUnresolvedMosaicId((String)transaction.getMosaicId()), (MosaicSupplyChangeActionType)MosaicSupplyChangeActionType.rawValueOf((int)transaction.getAction().getValue()), (BigInteger)transaction.getDelta());
    }

    @Override
    protected void copyToDto(MosaicSupplyChangeTransaction transaction, MosaicSupplyChangeTransactionDTO dto) {
        dto.setDelta(transaction.getDelta());
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setAction(MosaicSupplyChangeActionEnum.fromValue((Integer)transaction.getAction().getValue()));
    }
}

