/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.MosaicGlobalRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicGlobalRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicRestrictionType;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicGlobalRestrictionTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicRestrictionTypeEnum;
import java.math.BigInteger;

class MosaicGlobalRestrictionTransactionMapper
extends AbstractTransactionMapper<MosaicGlobalRestrictionTransactionDTO, MosaicGlobalRestrictionTransaction> {
    public MosaicGlobalRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_GLOBAL_RESTRICTION, MosaicGlobalRestrictionTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicGlobalRestrictionTransaction> createFactory(NetworkType networkType, MosaicGlobalRestrictionTransactionDTO transaction) {
        byte prevRestrictionType = transaction.getPreviousRestrictionType().getValue().byteValue();
        byte newRestrictionType = transaction.getNewRestrictionType().getValue().byteValue();
        MosaicGlobalRestrictionTransactionFactory factory = MosaicGlobalRestrictionTransactionFactory.create((NetworkType)networkType, (UnresolvedMosaicId)MapperUtils.toUnresolvedMosaicId((String)transaction.getMosaicId()), (BigInteger)MapperUtils.fromHexToBigInteger((String)transaction.getRestrictionKey()), (BigInteger)transaction.getNewRestrictionValue(), (MosaicRestrictionType)MosaicRestrictionType.rawValueOf((byte)newRestrictionType));
        if (transaction.getReferenceMosaicId() != null) {
            factory.referenceMosaicId(MapperUtils.toUnresolvedMosaicId((String)transaction.getReferenceMosaicId()));
        }
        return factory.previousRestrictionValue(transaction.getPreviousRestrictionValue()).previousRestrictionType(MosaicRestrictionType.rawValueOf((byte)prevRestrictionType));
    }

    @Override
    protected void copyToDto(MosaicGlobalRestrictionTransaction transaction, MosaicGlobalRestrictionTransactionDTO dto) {
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setRestrictionKey(transaction.getRestrictionKey().toString(16));
        dto.setNewRestrictionValue(transaction.getNewRestrictionValue());
        dto.setPreviousRestrictionValue(transaction.getPreviousRestrictionValue());
        dto.setPreviousRestrictionType(MosaicRestrictionTypeEnum.fromValue((Integer)Integer.valueOf(transaction.getPreviousRestrictionType().getValue())));
        dto.setNewRestrictionType(MosaicRestrictionTypeEnum.fromValue((Integer)Integer.valueOf(transaction.getNewRestrictionType().getValue())));
        dto.setReferenceMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getReferenceMosaicId()));
    }
}

