/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx.mappers;

import io.nem.symbol.sdk.infrastructure.vertx.mappers.AbstractTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.TransactionMapper;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionFactory;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.openapi.vertx.model.AggregateTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.CosignatureDTO;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class AggregateTransactionMapper
extends AbstractTransactionMapper<AggregateTransactionDTO, AggregateTransaction> {
    private TransactionMapper transactionMapper;

    public AggregateTransactionMapper(JsonHelper jsonHelper, TransactionType transactionType, TransactionMapper transactionMapper) {
        super(jsonHelper, transactionType, AggregateTransactionDTO.class);
        this.transactionMapper = transactionMapper;
    }

    protected AggregateTransactionFactory createFactory(NetworkType networkType, AggregateTransactionDTO transaction) {
        List transactions = transaction.getTransactions().stream().map((? super T embeddedTransactionInfoDTO) -> {
            EmbeddedTransactionInfoDTO transactionInfoDTO = new EmbeddedTransactionInfoDTO();
            transactionInfoDTO.setMeta(embeddedTransactionInfoDTO.getMeta());
            transactionInfoDTO.setTransaction(embeddedTransactionInfoDTO.getTransaction());
            Map innerTransaction = (Map)embeddedTransactionInfoDTO.getTransaction();
            innerTransaction.put("deadline", transaction.getDeadline());
            innerTransaction.put("maxFee", transaction.getMaxFee());
            innerTransaction.put("signature", transaction.getSignature());
            return this.transactionMapper.map(transactionInfoDTO);
        }).collect(Collectors.toList());
        List<Object> cosignatures = new ArrayList();
        if (transaction.getCosignatures() != null) {
            cosignatures = transaction.getCosignatures().stream().map((? super T aggregateCosignature) -> this.toCosignature(networkType, (CosignatureDTO)aggregateCosignature)).collect(Collectors.toList());
        }
        return AggregateTransactionFactory.create((TransactionType)this.getTransactionType(), (NetworkType)networkType, (String)transaction.getTransactionsHash(), transactions, cosignatures);
    }

    private AggregateTransactionCosignature toCosignature(NetworkType networkType, CosignatureDTO aggregateCosignature) {
        return new AggregateTransactionCosignature(aggregateCosignature.getSignature(), PublicAccount.createFromPublicKey((String)aggregateCosignature.getSignerPublicKey(), (NetworkType)networkType));
    }

    @Override
    protected void copyToDto(AggregateTransaction transaction, AggregateTransactionDTO dto) {
        List transactions = transaction.getInnerTransactions().stream().map((? super T embeddedTransactionInfoDTO) -> this.transactionMapper.mapToEmbedded((Transaction)embeddedTransactionInfoDTO)).collect(Collectors.toList());
        List<Object> cosignatures = new ArrayList();
        if (transaction.getCosignatures() != null) {
            cosignatures = transaction.getCosignatures().stream().map(this::toCosignature).collect(Collectors.toList());
        }
        dto.setTransactionsHash(transaction.getTransactionsHash());
        dto.setCosignatures(cosignatures);
        dto.setTransactions(transactions);
    }

    private CosignatureDTO toCosignature(AggregateTransactionCosignature aggregateCosignature) {
        CosignatureDTO cosignatureDTO = new CosignatureDTO();
        cosignatureDTO.setSignerPublicKey(aggregateCosignature.getSigner().getPublicKey().toHex());
        cosignatureDTO.setSignature(aggregateCosignature.getSignature());
        return cosignatureDTO;
    }
}

