/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.TransactionRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.GeneralTransactionMapper;
import io.nem.symbol.sdk.infrastructure.vertx.mappers.TransactionMapper;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionAnnounceResponse;
import io.nem.symbol.sdk.model.transaction.TransactionState;
import io.nem.symbol.sdk.model.transaction.TransactionStatus;
import io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionIds;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatusDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.function.Consumer;

public class TransactionRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements TransactionRepository {
    private final TransactionRoutesApi client;
    private final TransactionMapper transactionMapper;

    public TransactionRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new TransactionRoutesApiImpl(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public TransactionRoutesApi getClient() {
        return this.client;
    }

    public Observable<Transaction> getTransaction(String transactionHash) {
        Consumer callback = handler -> this.getClient().getTransaction(transactionHash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toTransaction));
    }

    private Transaction toTransaction(TransactionInfoDTO input) {
        return this.transactionMapper.map(input);
    }

    public Observable<List<Transaction>> getTransactions(List<String> transactionHashes) {
        Consumer callback = handler -> this.client.getTransactions(new TransactionIds().transactionIds(transactionHashes), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<TransactionStatus> getTransactionStatus(String transactionHash) {
        Consumer callback = handler -> this.getClient().getTransactionStatus(transactionHash, handler);
        return this.exceptionHandling(this.call(callback).map(this::toTransactionStatus));
    }

    private TransactionStatus toTransactionStatus(TransactionStatusDTO transactionStatusDTO) {
        return new TransactionStatus(TransactionState.valueOf((String)transactionStatusDTO.getGroup().name()), transactionStatusDTO.getCode() == null ? null : transactionStatusDTO.getCode().getValue(), transactionStatusDTO.getHash(), new Deadline(transactionStatusDTO.getDeadline()), transactionStatusDTO.getHeight());
    }

    public Observable<List<TransactionStatus>> getTransactionStatuses(List<String> transactionHashes) {
        Consumer callback = handler -> this.client.getTransactionsStatuses(new TransactionHashes().hashes(transactionHashes), handler);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransactionStatus).toList().toObservable());
    }

    public Observable<TransactionAnnounceResponse> announce(SignedTransaction signedTransaction) {
        Consumer callback = handler -> this.getClient().announceTransaction(new TransactionPayload().payload(signedTransaction.getPayload()), handler);
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    public Observable<TransactionAnnounceResponse> announceAggregateBonded(SignedTransaction signedTransaction) {
        Consumer callback = handler -> this.getClient().announcePartialTransaction(new TransactionPayload().payload(signedTransaction.getPayload()), handler);
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }

    public Observable<TransactionAnnounceResponse> announceAggregateBondedCosignature(CosignatureSignedTransaction cosignatureSignedTransaction) {
        Consumer callback = handler -> this.getClient().announceCosignatureTransaction(new Cosignature().parentHash(cosignatureSignedTransaction.getParentHash()).signature(cosignatureSignedTransaction.getSignature()).signerPublicKey(cosignatureSignedTransaction.getSignerPublicKey()), handler);
        return this.exceptionHandling(this.call(callback).map(dto -> new TransactionAnnounceResponse(dto.getMessage())));
    }
}

