/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.AccountRepository;
import io.nem.symbol.sdk.api.BlockRepository;
import io.nem.symbol.sdk.api.ChainRepository;
import io.nem.symbol.sdk.api.JsonSerialization;
import io.nem.symbol.sdk.api.Listener;
import io.nem.symbol.sdk.api.MetadataRepository;
import io.nem.symbol.sdk.api.MosaicRepository;
import io.nem.symbol.sdk.api.MultisigRepository;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.api.NetworkRepository;
import io.nem.symbol.sdk.api.NodeRepository;
import io.nem.symbol.sdk.api.ReceiptRepository;
import io.nem.symbol.sdk.api.RepositoryFactoryConfiguration;
import io.nem.symbol.sdk.api.RestrictionAccountRepository;
import io.nem.symbol.sdk.api.RestrictionMosaicRepository;
import io.nem.symbol.sdk.api.TransactionRepository;
import io.nem.symbol.sdk.infrastructure.RepositoryFactoryBase;
import io.nem.symbol.sdk.infrastructure.vertx.AccountRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.BlockRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.ChainRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.JsonHelperJackson2;
import io.nem.symbol.sdk.infrastructure.vertx.JsonSerializationVertx;
import io.nem.symbol.sdk.infrastructure.vertx.ListenerVertx;
import io.nem.symbol.sdk.infrastructure.vertx.MetadataRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.MosaicRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.MultisigRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.NamespaceRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.NetworkRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.NodeRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.ReceiptRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.RestrictionAccountRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.RestrictionMosaicRepositoryVertxImpl;
import io.nem.symbol.sdk.infrastructure.vertx.TransactionRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.reactivex.Observable;
import io.vertx.core.Vertx;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;

public class RepositoryFactoryVertxImpl
extends RepositoryFactoryBase {
    private final ApiClient apiClient;
    private final WebClient webClient;
    private final Vertx vertx = Vertx.vertx();

    public RepositoryFactoryVertxImpl(String baseUrl) {
        this(new RepositoryFactoryConfiguration(baseUrl));
    }

    public RepositoryFactoryVertxImpl(RepositoryFactoryConfiguration configuration) {
        super(configuration);
        this.webClient = WebClient.create((Vertx)this.vertx);
        this.apiClient = new ApiClient(this.vertx, new JsonObject().put("basePath", this.getBaseUrl())){

            public synchronized WebClient getWebClient() {
                return RepositoryFactoryVertxImpl.this.webClient;
            }
        };
        JsonHelperJackson2.configureMapper(this.apiClient.getObjectMapper());
        JsonHelperJackson2.configureMapper(Json.mapper);
    }

    public AccountRepository createAccountRepository() {
        return new AccountRepositoryVertxImpl(this.apiClient);
    }

    public MultisigRepository createMultisigRepository() {
        return new MultisigRepositoryVertxImpl(this.apiClient, (Observable<NetworkType>)this.getNetworkType());
    }

    public BlockRepository createBlockRepository() {
        return new BlockRepositoryVertxImpl(this.apiClient);
    }

    public ReceiptRepository createReceiptRepository() {
        return new ReceiptRepositoryVertxImpl(this.apiClient, (Observable<NetworkType>)this.getNetworkType());
    }

    public ChainRepository createChainRepository() {
        return new ChainRepositoryVertxImpl(this.apiClient);
    }

    public MosaicRepository createMosaicRepository() {
        return new MosaicRepositoryVertxImpl(this.apiClient, (Observable<NetworkType>)this.getNetworkType());
    }

    public NamespaceRepository createNamespaceRepository() {
        return new NamespaceRepositoryVertxImpl(this.apiClient, (Observable<NetworkType>)this.getNetworkType());
    }

    public NetworkRepository createNetworkRepository() {
        return new NetworkRepositoryVertxImpl(this.apiClient);
    }

    public NodeRepository createNodeRepository() {
        return new NodeRepositoryVertxImpl(this.apiClient);
    }

    public TransactionRepository createTransactionRepository() {
        return new TransactionRepositoryVertxImpl(this.apiClient);
    }

    public MetadataRepository createMetadataRepository() {
        return new MetadataRepositoryVertxImpl(this.apiClient);
    }

    public RestrictionAccountRepository createRestrictionAccountRepository() {
        return new RestrictionAccountRepositoryVertxImpl(this.apiClient);
    }

    public RestrictionMosaicRepository createRestrictionMosaicRepository() {
        return new RestrictionMosaicRepositoryVertxImpl(this.apiClient);
    }

    public Listener createListener() {
        return new ListenerVertx(this.vertx.createHttpClient(), this.getBaseUrl());
    }

    public JsonSerialization createJsonSerialization() {
        return new JsonSerializationVertx(this.apiClient.getObjectMapper());
    }

    public void close() {
        this.vertx.close();
        try {
            this.webClient.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

