/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.NodeRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.blockchain.ServerInfo;
import io.nem.symbol.sdk.model.blockchain.StorageInfo;
import io.nem.symbol.sdk.model.node.NodeHealth;
import io.nem.symbol.sdk.model.node.NodeInfo;
import io.nem.symbol.sdk.model.node.NodeStatus;
import io.nem.symbol.sdk.model.node.NodeTime;
import io.nem.symbol.sdk.model.node.RoleType;
import io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.NodeInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NodeTimeDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ServerDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ServerInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.StorageInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class NodeRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NodeRepository {
    private final NodeRoutesApi client;

    public NodeRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new NodeRoutesApiImpl(apiClient);
    }

    public NodeRoutesApi getClient() {
        return this.client;
    }

    public Observable<NodeInfo> getNodeInfo() {
        Consumer callback = handler -> this.getClient().getNodeInfo(handler);
        return this.exceptionHandling(this.call(callback).map(this::toNodeInfo));
    }

    public Observable<List<NodeInfo>> getNodePeers() {
        Consumer callback = handler -> this.getClient().getNodePeers(handler);
        return this.exceptionHandling(this.call(callback).map(l -> l.stream().map(this::toNodeInfo).collect(Collectors.toList())));
    }

    private NodeInfo toNodeInfo(NodeInfoDTO nodeInfoDTO) {
        return new NodeInfo(nodeInfoDTO.getPublicKey(), nodeInfoDTO.getPort().intValue(), NetworkType.rawValueOf((int)nodeInfoDTO.getNetworkIdentifier()), nodeInfoDTO.getVersion().intValue(), RoleType.rawValueOf((int)nodeInfoDTO.getRoles().getValue()), nodeInfoDTO.getHost(), nodeInfoDTO.getFriendlyName(), nodeInfoDTO.getNetworkGenerationHash());
    }

    public Observable<NodeTime> getNodeTime() {
        Consumer callback = handler -> this.getClient().getNodeTime(handler);
        return this.exceptionHandling(this.call(callback).map(this::toNodeTime));
    }

    private NodeTime toNodeTime(NodeTimeDTO nodeTimeDTO) {
        BigInteger sendTimestamp = nodeTimeDTO.getCommunicationTimestamps().getSendTimestamp();
        BigInteger receiveTimestamp = nodeTimeDTO.getCommunicationTimestamps().getReceiveTimestamp();
        return new NodeTime(sendTimestamp, receiveTimestamp);
    }

    public Observable<StorageInfo> getNodeStorage() {
        Consumer callback = arg_0 -> ((NodeRoutesApi)this.getClient()).getNodeStorage(arg_0);
        return this.exceptionHandling(this.call(callback).map(this::toStorageInfo));
    }

    private StorageInfo toStorageInfo(StorageInfoDTO storageInfoDTO) {
        return new StorageInfo(storageInfoDTO.getNumAccounts(), storageInfoDTO.getNumBlocks(), storageInfoDTO.getNumTransactions());
    }

    public Observable<NodeHealth> getNodeHealth() {
        Consumer callback = arg_0 -> ((NodeRoutesApi)this.getClient()).getNodeHealth(arg_0);
        return this.exceptionHandling(this.call(callback).map(dto -> new NodeHealth(NodeStatus.rawValueOf((String)dto.getStatus().getApiNode().getValue()), NodeStatus.rawValueOf((String)dto.getStatus().getDb().getValue()))));
    }

    public Observable<ServerInfo> getServerInfo() {
        Consumer callback = arg_0 -> ((NodeRoutesApi)this.getClient()).getServerInfo(arg_0);
        return this.exceptionHandling(this.call(callback).map(ServerInfoDTO::getServerInfo).map(this::toServerInfo));
    }

    private ServerInfo toServerInfo(ServerDTO serverInfoDTO) {
        return new ServerInfo(serverInfoDTO.getRestVersion(), serverInfoDTO.getSdkVersion());
    }
}

