/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.sdk.api.NetworkRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.blockchain.NetworkFees;
import io.nem.symbol.sdk.model.blockchain.NetworkInfo;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.reactivex.Observable;
import java.util.function.Consumer;

public class NetworkRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements NetworkRepository {
    private final NetworkRoutesApi networkRoutesApi;
    private final NodeRoutesApi nodeRoutesApi;

    public NetworkRepositoryVertxImpl(ApiClient apiClient) {
        super(apiClient);
        this.networkRoutesApi = new NetworkRoutesApiImpl(apiClient);
        this.nodeRoutesApi = new NodeRoutesApiImpl(apiClient);
    }

    public Observable<NetworkType> getNetworkType() {
        Consumer callback = handler -> this.getNodeRoutesApi().getNodeInfo(handler);
        return this.exceptionHandling(this.call(callback).map(info -> NetworkType.rawValueOf((int)info.getNetworkIdentifier())));
    }

    public Observable<NetworkFees> getNetworkFees() {
        Consumer callback = handler -> this.getNetworkRoutesApi().getNetworkFees(handler);
        return this.exceptionHandling(this.call(callback).map(info -> new NetworkFees(info.getAverageFeeMultiplier(), info.getMedianFeeMultiplier(), info.getLowestFeeMultiplier(), info.getHighestFeeMultiplier())));
    }

    public Observable<NetworkInfo> getNetworkInfo() {
        Consumer callback = handler -> this.getNetworkRoutesApi().getNetworkType(handler);
        return this.exceptionHandling(this.call(callback).map(info -> new NetworkInfo(info.getName(), info.getDescription())));
    }

    public NetworkRoutesApi getNetworkRoutesApi() {
        return this.networkRoutesApi;
    }

    public NodeRoutesApi getNodeRoutesApi() {
        return this.nodeRoutesApi;
    }
}

