/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure.vertx;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.MosaicRepository;
import io.nem.symbol.sdk.infrastructure.vertx.AbstractRepositoryVertxImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.NetworkType;
import io.nem.symbol.sdk.model.mosaic.MosaicFlags;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicInfo;
import io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApiImpl;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsInfoDTO;
import io.reactivex.Observable;
import io.vertx.core.Handler;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MosaicRepositoryVertxImpl
extends AbstractRepositoryVertxImpl
implements MosaicRepository {
    private final MosaicRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public MosaicRepositoryVertxImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new MosaicRoutesApiImpl(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public MosaicRoutesApi getClient() {
        return this.client;
    }

    public Observable<MosaicInfo> getMosaic(MosaicId mosaicId) {
        Consumer<Handler> callback = handler -> this.getClient().getMosaic(mosaicId.getIdAsHex(), handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicInfoDTO)mosaicInfoDTO, (NetworkType)networkType))));
    }

    public Observable<List<MosaicInfo>> getMosaics(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Consumer<Handler> callback = handler -> this.getClient().getMosaics(mosaicIds, handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).flatMapIterable(item -> item).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicInfoDTO)mosaicInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<MosaicInfo>> getMosaicsFromAccount(Address address) {
        Consumer<Handler> callback = handler -> this.getClient().getMosaicsFromAccount(address.plain(), handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(MosaicsInfoDTO::getMosaics).flatMapIterable(item -> item).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicDTO)mosaicInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<MosaicInfo>> getMosaicsFromAccounts(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Consumer<Handler> callback = handler -> this.getClient().getMosaicsFromAccounts(accountIds, handler);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(MosaicsInfoDTO::getMosaics).flatMapIterable(item -> item).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicDTO)mosaicInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    private MosaicInfo createMosaicInfo(MosaicInfoDTO mosaicInfoDTO, NetworkType networkType) {
        return this.createMosaicInfo(mosaicInfoDTO.getMosaic(), networkType);
    }

    private MosaicInfo createMosaicInfo(MosaicDTO mosaic, NetworkType networkType) {
        return MosaicInfo.create((MosaicId)MapperUtils.toMosaicId((String)mosaic.getId()), (BigInteger)mosaic.getSupply(), (BigInteger)mosaic.getStartHeight(), (PublicAccount)new PublicAccount(mosaic.getOwnerPublicKey(), networkType), (Integer)mosaic.getRevision(), (MosaicFlags)MosaicRepositoryVertxImpl.extractMosaicFlags(mosaic), (int)mosaic.getDivisibility(), (BigInteger)mosaic.getDuration());
    }

    private static MosaicFlags extractMosaicFlags(MosaicDTO mosaicDTO) {
        return MosaicFlags.create((int)mosaicDTO.getFlags());
    }
}

