/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.vertx.model.LockStatus;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@JsonPropertyOrder(value={"version", "ownerAddress", "mosaicId", "amount", "endHeight", "status", "hashAlgorithm", "secret", "recipientAddress", "compositeHash"})
public class SecretLockEntryDTO {
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_OWNER_ADDRESS = "ownerAddress";
    private String ownerAddress;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount = null;
    public static final String JSON_PROPERTY_END_HEIGHT = "endHeight";
    private BigInteger endHeight = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private LockStatus status;
    public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
    private LockHashAlgorithmEnum hashAlgorithm;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;
    public static final String JSON_PROPERTY_COMPOSITE_HASH = "compositeHash";
    private String compositeHash;

    public SecretLockEntryDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The version of the state")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public SecretLockEntryDTO ownerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        return this;
    }

    @ApiModelProperty(example="TADP6C2GVEG654OP5LZI32P2GYJSCMEGQBYB7QY", required=true, value="Address encoded using a 32-character set.")
    @JsonProperty(value="ownerAddress")
    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public SecretLockEntryDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public SecretLockEntryDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="amount")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public SecretLockEntryDTO endHeight(BigInteger endHeight) {
        this.endHeight = endHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="endHeight")
    public BigInteger getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(BigInteger endHeight) {
        this.endHeight = endHeight;
    }

    public SecretLockEntryDTO status(LockStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    public LockStatus getStatus() {
        return this.status;
    }

    public void setStatus(LockStatus status) {
        this.status = status;
    }

    public SecretLockEntryDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hashAlgorithm")
    public LockHashAlgorithmEnum getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public SecretLockEntryDTO secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="FB8558E82C1968A3536CD77ACD7F9BC65E8B8F346714C9F91B42D6C2177BEDC1", required=true, value="Secret.")
    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SecretLockEntryDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="TADP6C2GVEG654OP5LZI32P2GYJSCMEGQBYB7QY", required=true, value="Address encoded using a 32-character set.")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public SecretLockEntryDTO compositeHash(String compositeHash) {
        this.compositeHash = compositeHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="compositeHash")
    public String getCompositeHash() {
        return this.compositeHash;
    }

    public void setCompositeHash(String compositeHash) {
        this.compositeHash = compositeHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretLockEntryDTO secretLockEntryDTO = (SecretLockEntryDTO)o;
        return Objects.equals(this.version, secretLockEntryDTO.version) && Objects.equals(this.ownerAddress, secretLockEntryDTO.ownerAddress) && Objects.equals(this.mosaicId, secretLockEntryDTO.mosaicId) && Objects.equals(this.amount, secretLockEntryDTO.amount) && Objects.equals(this.endHeight, secretLockEntryDTO.endHeight) && Objects.equals((Object)this.status, (Object)secretLockEntryDTO.status) && Objects.equals((Object)this.hashAlgorithm, (Object)secretLockEntryDTO.hashAlgorithm) && Objects.equals(this.secret, secretLockEntryDTO.secret) && Objects.equals(this.recipientAddress, secretLockEntryDTO.recipientAddress) && Objects.equals(this.compositeHash, secretLockEntryDTO.compositeHash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.ownerAddress, this.mosaicId, this.amount, this.endHeight, this.status, this.hashAlgorithm, this.secret, this.recipientAddress, this.compositeHash});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecretLockEntryDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    ownerAddress: ").append(this.toIndentedString(this.ownerAddress)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    endHeight: ").append(this.toIndentedString(this.endHeight)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.hashAlgorithm)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    compositeHash: ").append(this.toIndentedString(this.compositeHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

