/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@JsonPropertyOrder(value={"sourceAddress", "mosaicId", "amount"})
public class MosaicSupplyRevocationTransactionBodyDTO {
    public static final String JSON_PROPERTY_SOURCE_ADDRESS = "sourceAddress";
    private String sourceAddress;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount = null;

    public MosaicSupplyRevocationTransactionBodyDTO sourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    @ApiModelProperty(example="TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA", required=true, value="Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA ")
    @JsonProperty(value="sourceAddress")
    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public MosaicSupplyRevocationTransactionBodyDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public MosaicSupplyRevocationTransactionBodyDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="amount")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicSupplyRevocationTransactionBodyDTO mosaicSupplyRevocationTransactionBodyDTO = (MosaicSupplyRevocationTransactionBodyDTO)o;
        return Objects.equals(this.sourceAddress, mosaicSupplyRevocationTransactionBodyDTO.sourceAddress) && Objects.equals(this.mosaicId, mosaicSupplyRevocationTransactionBodyDTO.mosaicId) && Objects.equals(this.amount, mosaicSupplyRevocationTransactionBodyDTO.amount);
    }

    public int hashCode() {
        return Objects.hash(this.sourceAddress, this.mosaicId, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicSupplyRevocationTransactionBodyDTO {\n");
        sb.append("    sourceAddress: ").append(this.toIndentedString(this.sourceAddress)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

