/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.vertx.model.AccountTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ActivityBucketDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Mosaic;
import io.nem.symbol.sdk.openapi.vertx.model.SupplementalPublicKeysDTO;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"version", "address", "addressHeight", "publicKey", "publicKeyHeight", "accountType", "supplementalPublicKeys", "activityBuckets", "mosaics", "importance", "importanceHeight"})
public class AccountDTO {
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_ADDRESS_HEIGHT = "addressHeight";
    private BigInteger addressHeight = null;
    public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
    private String publicKey;
    public static final String JSON_PROPERTY_PUBLIC_KEY_HEIGHT = "publicKeyHeight";
    private BigInteger publicKeyHeight = null;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    private AccountTypeEnum accountType;
    public static final String JSON_PROPERTY_SUPPLEMENTAL_PUBLIC_KEYS = "supplementalPublicKeys";
    private SupplementalPublicKeysDTO supplementalPublicKeys;
    public static final String JSON_PROPERTY_ACTIVITY_BUCKETS = "activityBuckets";
    private List<ActivityBucketDTO> activityBuckets = new ArrayList<ActivityBucketDTO>();
    public static final String JSON_PROPERTY_MOSAICS = "mosaics";
    private List<Mosaic> mosaics = new ArrayList<Mosaic>();
    public static final String JSON_PROPERTY_IMPORTANCE = "importance";
    private BigInteger importance = null;
    public static final String JSON_PROPERTY_IMPORTANCE_HEIGHT = "importanceHeight";
    private BigInteger importanceHeight = null;

    public AccountDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The version of the state")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AccountDTO address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="TADP6C2GVEG654OP5LZI32P2GYJSCMEGQBYB7QY", required=true, value="Address encoded using a 32-character set.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AccountDTO addressHeight(BigInteger addressHeight) {
        this.addressHeight = addressHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="addressHeight")
    public BigInteger getAddressHeight() {
        return this.addressHeight;
    }

    public void setAddressHeight(BigInteger addressHeight) {
        this.addressHeight = addressHeight;
    }

    public AccountDTO publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="publicKey")
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public AccountDTO publicKeyHeight(BigInteger publicKeyHeight) {
        this.publicKeyHeight = publicKeyHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="publicKeyHeight")
    public BigInteger getPublicKeyHeight() {
        return this.publicKeyHeight;
    }

    public void setPublicKeyHeight(BigInteger publicKeyHeight) {
        this.publicKeyHeight = publicKeyHeight;
    }

    public AccountDTO accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="accountType")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public AccountDTO supplementalPublicKeys(SupplementalPublicKeysDTO supplementalPublicKeys) {
        this.supplementalPublicKeys = supplementalPublicKeys;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplementalPublicKeys")
    public SupplementalPublicKeysDTO getSupplementalPublicKeys() {
        return this.supplementalPublicKeys;
    }

    public void setSupplementalPublicKeys(SupplementalPublicKeysDTO supplementalPublicKeys) {
        this.supplementalPublicKeys = supplementalPublicKeys;
    }

    public AccountDTO activityBuckets(List<ActivityBucketDTO> activityBuckets) {
        this.activityBuckets = activityBuckets;
        return this;
    }

    public AccountDTO addActivityBucketsItem(ActivityBucketDTO activityBucketsItem) {
        this.activityBuckets.add(activityBucketsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="activityBuckets")
    public List<ActivityBucketDTO> getActivityBuckets() {
        return this.activityBuckets;
    }

    public void setActivityBuckets(List<ActivityBucketDTO> activityBuckets) {
        this.activityBuckets = activityBuckets;
    }

    public AccountDTO mosaics(List<Mosaic> mosaics) {
        this.mosaics = mosaics;
        return this;
    }

    public AccountDTO addMosaicsItem(Mosaic mosaicsItem) {
        this.mosaics.add(mosaicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Mosaic units owned.")
    @JsonProperty(value="mosaics")
    public List<Mosaic> getMosaics() {
        return this.mosaics;
    }

    public void setMosaics(List<Mosaic> mosaics) {
        this.mosaics = mosaics;
    }

    public AccountDTO importance(BigInteger importance) {
        this.importance = importance;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Probability of an account to harvest the next block.")
    @JsonProperty(value="importance")
    public BigInteger getImportance() {
        return this.importance;
    }

    public void setImportance(BigInteger importance) {
        this.importance = importance;
    }

    public AccountDTO importanceHeight(BigInteger importanceHeight) {
        this.importanceHeight = importanceHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="importanceHeight")
    public BigInteger getImportanceHeight() {
        return this.importanceHeight;
    }

    public void setImportanceHeight(BigInteger importanceHeight) {
        this.importanceHeight = importanceHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDTO accountDTO = (AccountDTO)o;
        return Objects.equals(this.version, accountDTO.version) && Objects.equals(this.address, accountDTO.address) && Objects.equals(this.addressHeight, accountDTO.addressHeight) && Objects.equals(this.publicKey, accountDTO.publicKey) && Objects.equals(this.publicKeyHeight, accountDTO.publicKeyHeight) && Objects.equals((Object)this.accountType, (Object)accountDTO.accountType) && Objects.equals(this.supplementalPublicKeys, accountDTO.supplementalPublicKeys) && Objects.equals(this.activityBuckets, accountDTO.activityBuckets) && Objects.equals(this.mosaics, accountDTO.mosaics) && Objects.equals(this.importance, accountDTO.importance) && Objects.equals(this.importanceHeight, accountDTO.importanceHeight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.address, this.addressHeight, this.publicKey, this.publicKeyHeight, this.accountType, this.supplementalPublicKeys, this.activityBuckets, this.mosaics, this.importance, this.importanceHeight});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    addressHeight: ").append(this.toIndentedString(this.addressHeight)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    publicKeyHeight: ").append(this.toIndentedString(this.publicKeyHeight)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    supplementalPublicKeys: ").append(this.toIndentedString(this.supplementalPublicKeys)).append("\n");
        sb.append("    activityBuckets: ").append(this.toIndentedString(this.activityBuckets)).append("\n");
        sb.append("    mosaics: ").append(this.toIndentedString(this.mosaics)).append("\n");
        sb.append("    importance: ").append(this.toIndentedString(this.importance)).append("\n");
        sb.append("    importanceHeight: ").append(this.toIndentedString(this.importanceHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

