/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;

public class RestrictionAccountRoutesApiImpl
implements RestrictionAccountRoutesApi {
    private ApiClient apiClient;

    public RestrictionAccountRoutesApiImpl() {
        this(null);
    }

    public RestrictionAccountRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getAccountRestrictions(String address, Handler<AsyncResult<AccountRestrictionsInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountRestrictions"));
            return;
        }
        String localVarPath = "/restrictions/account/{address}".replaceAll("\\{address\\}", address.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<AccountRestrictionsInfoDTO> localVarReturnType = new TypeReference<AccountRestrictionsInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getAccountRestrictionsMerkle(String address, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountRestrictionsMerkle"));
            return;
        }
        String localVarPath = "/restrictions/account/{address}/merkle".replaceAll("\\{address\\}", address.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MerkleStateInfoDTO> localVarReturnType = new TypeReference<MerkleStateInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void searchAccountRestrictions(String address, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<AccountRestrictionsPage>> resultHandler) {
        Object localVarBody = null;
        String localVarPath = "/restrictions/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<AccountRestrictionsPage> localVarReturnType = new TypeReference<AccountRestrictionsPage>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

