package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountGraphInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountInfoDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-11-12T11:59:12.877Z[UTC]")
public class MultisigRoutesApiImpl implements MultisigRoutesApi {

    private ApiClient apiClient;

    public MultisigRoutesApiImpl() {
        this(null);
    }

    public MultisigRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisig(String address, Handler<AsyncResult<MultisigAccountInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'address' is set
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMultisig"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{address}/multisig".replaceAll("\\{" + "address" + "\\}", address.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MultisigAccountInfoDTO> localVarReturnType = new TypeReference<MultisigAccountInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisigGraph(String address, Handler<AsyncResult<List<MultisigAccountGraphInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'address' is set
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMultisigGraph"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{address}/multisig/graph".replaceAll("\\{" + "address" + "\\}", address.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<MultisigAccountGraphInfoDTO>> localVarReturnType = new TypeReference<List<MultisigAccountGraphInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get multisig account merkle information
     * Returns the multisig account merkle information.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisigMerkle(String address, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'address' is set
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMultisigMerkle"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{address}/multisig/merkle".replaceAll("\\{" + "address" + "\\}", address.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleStateInfoDTO> localVarReturnType = new TypeReference<MerkleStateInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
