/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.UnresolvedMosaic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * TransferTransactionBodyDTO
 */
@JsonPropertyOrder({
  TransferTransactionBodyDTO.JSON_PROPERTY_RECIPIENT_ADDRESS,
  TransferTransactionBodyDTO.JSON_PROPERTY_MOSAICS,
  TransferTransactionBodyDTO.JSON_PROPERTY_MESSAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:35:16.459Z[UTC]")
public class TransferTransactionBodyDTO {
  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;

  public static final String JSON_PROPERTY_MOSAICS = "mosaics";
  private List<UnresolvedMosaic> mosaics = new ArrayList<>();

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;


  public TransferTransactionBodyDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA 
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA", required = true, value = "Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA ")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  public TransferTransactionBodyDTO mosaics(List<UnresolvedMosaic> mosaics) {
    
    this.mosaics = mosaics;
    return this;
  }

  public TransferTransactionBodyDTO addMosaicsItem(UnresolvedMosaic mosaicsItem) {
    this.mosaics.add(mosaicsItem);
    return this;
  }

   /**
   * Array of mosaics sent to the recipient. 
   * @return mosaics
  **/
  @ApiModelProperty(required = true, value = "Array of mosaics sent to the recipient. ")
  @JsonProperty(JSON_PROPERTY_MOSAICS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<UnresolvedMosaic> getMosaics() {
    return mosaics;
  }


  public void setMosaics(List<UnresolvedMosaic> mosaics) {
    this.mosaics = mosaics;
  }


  public TransferTransactionBodyDTO message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * Transfer transaction message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Transfer transaction message")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferTransactionBodyDTO transferTransactionBodyDTO = (TransferTransactionBodyDTO) o;
    return Objects.equals(this.recipientAddress, transferTransactionBodyDTO.recipientAddress) &&
        Objects.equals(this.mosaics, transferTransactionBodyDTO.mosaics) &&
        Objects.equals(this.message, transferTransactionBodyDTO.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(recipientAddress, mosaics, message);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferTransactionBodyDTO {\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("    mosaics: ").append(toIndentedString(mosaics)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

