/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.vertx.model.LockStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * SecretLockEntryDTO
 */
@JsonPropertyOrder({
  SecretLockEntryDTO.JSON_PROPERTY_VERSION,
  SecretLockEntryDTO.JSON_PROPERTY_OWNER_ADDRESS,
  SecretLockEntryDTO.JSON_PROPERTY_MOSAIC_ID,
  SecretLockEntryDTO.JSON_PROPERTY_AMOUNT,
  SecretLockEntryDTO.JSON_PROPERTY_END_HEIGHT,
  SecretLockEntryDTO.JSON_PROPERTY_STATUS,
  SecretLockEntryDTO.JSON_PROPERTY_HASH_ALGORITHM,
  SecretLockEntryDTO.JSON_PROPERTY_SECRET,
  SecretLockEntryDTO.JSON_PROPERTY_RECIPIENT_ADDRESS,
  SecretLockEntryDTO.JSON_PROPERTY_COMPOSITE_HASH
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:35:16.459Z[UTC]")
public class SecretLockEntryDTO {
  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_OWNER_ADDRESS = "ownerAddress";
  private String ownerAddress;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount = null;

  public static final String JSON_PROPERTY_END_HEIGHT = "endHeight";
  private java.math.BigInteger endHeight = null;

  public static final String JSON_PROPERTY_STATUS = "status";
  private LockStatus status;

  public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
  private LockHashAlgorithmEnum hashAlgorithm;

  public static final String JSON_PROPERTY_SECRET = "secret";
  private String secret;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;

  public static final String JSON_PROPERTY_COMPOSITE_HASH = "compositeHash";
  private String compositeHash;


  public SecretLockEntryDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * The version of the state
   * @return version
  **/
  @ApiModelProperty(example = "1", required = true, value = "The version of the state")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public SecretLockEntryDTO ownerAddress(String ownerAddress) {
    
    this.ownerAddress = ownerAddress;
    return this;
  }

   /**
   * Address encoded using a 32-character set.
   * @return ownerAddress
  **/
  @ApiModelProperty(example = "TADP6C2GVEG654OP5LZI32P2GYJSCMEGQBYB7QY", required = true, value = "Address encoded using a 32-character set.")
  @JsonProperty(JSON_PROPERTY_OWNER_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerAddress() {
    return ownerAddress;
  }


  public void setOwnerAddress(String ownerAddress) {
    this.ownerAddress = ownerAddress;
  }


  public SecretLockEntryDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier.
   * @return mosaicId
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Mosaic identifier.")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public SecretLockEntryDTO amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return amount
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  public SecretLockEntryDTO endHeight(java.math.BigInteger endHeight) {
    
    this.endHeight = endHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return endHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_END_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getEndHeight() {
    return endHeight;
  }


  public void setEndHeight(java.math.BigInteger endHeight) {
    this.endHeight = endHeight;
  }


  public SecretLockEntryDTO status(LockStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LockStatus getStatus() {
    return status;
  }


  public void setStatus(LockStatus status) {
    this.status = status;
  }


  public SecretLockEntryDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    
    this.hashAlgorithm = hashAlgorithm;
    return this;
  }

   /**
   * Get hashAlgorithm
   * @return hashAlgorithm
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HASH_ALGORITHM)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LockHashAlgorithmEnum getHashAlgorithm() {
    return hashAlgorithm;
  }


  public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
  }


  public SecretLockEntryDTO secret(String secret) {
    
    this.secret = secret;
    return this;
  }

   /**
   * Secret.
   * @return secret
  **/
  @ApiModelProperty(example = "FB8558E82C1968A3536CD77ACD7F9BC65E8B8F346714C9F91B42D6C2177BEDC1", required = true, value = "Secret.")
  @JsonProperty(JSON_PROPERTY_SECRET)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSecret() {
    return secret;
  }


  public void setSecret(String secret) {
    this.secret = secret;
  }


  public SecretLockEntryDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address encoded using a 32-character set.
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "TADP6C2GVEG654OP5LZI32P2GYJSCMEGQBYB7QY", required = true, value = "Address encoded using a 32-character set.")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  public SecretLockEntryDTO compositeHash(String compositeHash) {
    
    this.compositeHash = compositeHash;
    return this;
  }

   /**
   * Get compositeHash
   * @return compositeHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COMPOSITE_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCompositeHash() {
    return compositeHash;
  }


  public void setCompositeHash(String compositeHash) {
    this.compositeHash = compositeHash;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecretLockEntryDTO secretLockEntryDTO = (SecretLockEntryDTO) o;
    return Objects.equals(this.version, secretLockEntryDTO.version) &&
        Objects.equals(this.ownerAddress, secretLockEntryDTO.ownerAddress) &&
        Objects.equals(this.mosaicId, secretLockEntryDTO.mosaicId) &&
        Objects.equals(this.amount, secretLockEntryDTO.amount) &&
        Objects.equals(this.endHeight, secretLockEntryDTO.endHeight) &&
        Objects.equals(this.status, secretLockEntryDTO.status) &&
        Objects.equals(this.hashAlgorithm, secretLockEntryDTO.hashAlgorithm) &&
        Objects.equals(this.secret, secretLockEntryDTO.secret) &&
        Objects.equals(this.recipientAddress, secretLockEntryDTO.recipientAddress) &&
        Objects.equals(this.compositeHash, secretLockEntryDTO.compositeHash);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, ownerAddress, mosaicId, amount, endHeight, status, hashAlgorithm, secret, recipientAddress, compositeHash);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecretLockEntryDTO {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    ownerAddress: ").append(toIndentedString(ownerAddress)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    endHeight: ").append(toIndentedString(endHeight)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    hashAlgorithm: ").append(toIndentedString(hashAlgorithm)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("    compositeHash: ").append(toIndentedString(compositeHash)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

