/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockTransactionBodyDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * EmbeddedSecretLockTransactionDTO
 */
@JsonPropertyOrder({
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_VERSION,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_NETWORK,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_TYPE,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_RECIPIENT_ADDRESS,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_SECRET,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_MOSAIC_ID,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_AMOUNT,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_DURATION,
  EmbeddedSecretLockTransactionDTO.JSON_PROPERTY_HASH_ALGORITHM
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:35:16.459Z[UTC]")
public class EmbeddedSecretLockTransactionDTO {
  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;

  public static final String JSON_PROPERTY_SECRET = "secret";
  private String secret;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount = null;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private java.math.BigInteger duration = null;

  public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
  private LockHashAlgorithmEnum hashAlgorithm;


  public EmbeddedSecretLockTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public EmbeddedSecretLockTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public EmbeddedSecretLockTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public EmbeddedSecretLockTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public EmbeddedSecretLockTransactionDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA 
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA", required = true, value = "Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA ")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  public EmbeddedSecretLockTransactionDTO secret(String secret) {
    
    this.secret = secret;
    return this;
  }

   /**
   * Get secret
   * @return secret
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SECRET)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSecret() {
    return secret;
  }


  public void setSecret(String secret) {
    this.secret = secret;
  }


  public EmbeddedSecretLockTransactionDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return mosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public EmbeddedSecretLockTransactionDTO amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return amount
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  public EmbeddedSecretLockTransactionDTO duration(java.math.BigInteger duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return duration
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DURATION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDuration() {
    return duration;
  }


  public void setDuration(java.math.BigInteger duration) {
    this.duration = duration;
  }


  public EmbeddedSecretLockTransactionDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    
    this.hashAlgorithm = hashAlgorithm;
    return this;
  }

   /**
   * Get hashAlgorithm
   * @return hashAlgorithm
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HASH_ALGORITHM)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LockHashAlgorithmEnum getHashAlgorithm() {
    return hashAlgorithm;
  }


  public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedSecretLockTransactionDTO embeddedSecretLockTransactionDTO = (EmbeddedSecretLockTransactionDTO) o;
    return Objects.equals(this.signerPublicKey, embeddedSecretLockTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, embeddedSecretLockTransactionDTO.version) &&
        Objects.equals(this.network, embeddedSecretLockTransactionDTO.network) &&
        Objects.equals(this.type, embeddedSecretLockTransactionDTO.type) &&
        Objects.equals(this.recipientAddress, embeddedSecretLockTransactionDTO.recipientAddress) &&
        Objects.equals(this.secret, embeddedSecretLockTransactionDTO.secret) &&
        Objects.equals(this.mosaicId, embeddedSecretLockTransactionDTO.mosaicId) &&
        Objects.equals(this.amount, embeddedSecretLockTransactionDTO.amount) &&
        Objects.equals(this.duration, embeddedSecretLockTransactionDTO.duration) &&
        Objects.equals(this.hashAlgorithm, embeddedSecretLockTransactionDTO.hashAlgorithm);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signerPublicKey, version, network, type, recipientAddress, secret, mosaicId, amount, duration, hashAlgorithm);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedSecretLockTransactionDTO {\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    hashAlgorithm: ").append(toIndentedString(hashAlgorithm)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

