/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * BlockMetaDTO
 */
@JsonPropertyOrder({
  BlockMetaDTO.JSON_PROPERTY_HASH,
  BlockMetaDTO.JSON_PROPERTY_TOTAL_FEE,
  BlockMetaDTO.JSON_PROPERTY_GENERATION_HASH,
  BlockMetaDTO.JSON_PROPERTY_STATE_HASH_SUB_CACHE_MERKLE_ROOTS,
  BlockMetaDTO.JSON_PROPERTY_TOTAL_TRANSACTIONS_COUNT,
  BlockMetaDTO.JSON_PROPERTY_TRANSACTIONS_COUNT,
  BlockMetaDTO.JSON_PROPERTY_STATEMENTS_COUNT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:35:16.459Z[UTC]")
public class BlockMetaDTO {
  public static final String JSON_PROPERTY_HASH = "hash";
  private String hash;

  public static final String JSON_PROPERTY_TOTAL_FEE = "totalFee";
  private java.math.BigInteger totalFee = null;

  public static final String JSON_PROPERTY_GENERATION_HASH = "generationHash";
  private String generationHash;

  public static final String JSON_PROPERTY_STATE_HASH_SUB_CACHE_MERKLE_ROOTS = "stateHashSubCacheMerkleRoots";
  private List<String> stateHashSubCacheMerkleRoots = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_TRANSACTIONS_COUNT = "totalTransactionsCount";
  private Integer totalTransactionsCount;

  public static final String JSON_PROPERTY_TRANSACTIONS_COUNT = "transactionsCount";
  private Integer transactionsCount;

  public static final String JSON_PROPERTY_STATEMENTS_COUNT = "statementsCount";
  private Integer statementsCount;


  public BlockMetaDTO hash(String hash) {
    
    this.hash = hash;
    return this;
  }

   /**
   * Get hash
   * @return hash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHash() {
    return hash;
  }


  public void setHash(String hash) {
    this.hash = hash;
  }


  public BlockMetaDTO totalFee(java.math.BigInteger totalFee) {
    
    this.totalFee = totalFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return totalFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_TOTAL_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getTotalFee() {
    return totalFee;
  }


  public void setTotalFee(java.math.BigInteger totalFee) {
    this.totalFee = totalFee;
  }


  public BlockMetaDTO generationHash(String generationHash) {
    
    this.generationHash = generationHash;
    return this;
  }

   /**
   * Get generationHash
   * @return generationHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_GENERATION_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGenerationHash() {
    return generationHash;
  }


  public void setGenerationHash(String generationHash) {
    this.generationHash = generationHash;
  }


  public BlockMetaDTO stateHashSubCacheMerkleRoots(List<String> stateHashSubCacheMerkleRoots) {
    
    this.stateHashSubCacheMerkleRoots = stateHashSubCacheMerkleRoots;
    return this;
  }

  public BlockMetaDTO addStateHashSubCacheMerkleRootsItem(String stateHashSubCacheMerkleRootsItem) {
    this.stateHashSubCacheMerkleRoots.add(stateHashSubCacheMerkleRootsItem);
    return this;
  }

   /**
   * Get stateHashSubCacheMerkleRoots
   * @return stateHashSubCacheMerkleRoots
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATE_HASH_SUB_CACHE_MERKLE_ROOTS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getStateHashSubCacheMerkleRoots() {
    return stateHashSubCacheMerkleRoots;
  }


  public void setStateHashSubCacheMerkleRoots(List<String> stateHashSubCacheMerkleRoots) {
    this.stateHashSubCacheMerkleRoots = stateHashSubCacheMerkleRoots;
  }


  public BlockMetaDTO totalTransactionsCount(Integer totalTransactionsCount) {
    
    this.totalTransactionsCount = totalTransactionsCount;
    return this;
  }

   /**
   * Total number of [transactions](https://docs.symbolplatform.com/concepts/transaction.html) confirmed in this block, including *embedded* transactions (i.e. transactions contained within aggregate transactions). 
   * @return totalTransactionsCount
  **/
  @ApiModelProperty(example = "1", required = true, value = "Total number of [transactions](https://docs.symbolplatform.com/concepts/transaction.html) confirmed in this block, including *embedded* transactions (i.e. transactions contained within aggregate transactions). ")
  @JsonProperty(JSON_PROPERTY_TOTAL_TRANSACTIONS_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTotalTransactionsCount() {
    return totalTransactionsCount;
  }


  public void setTotalTransactionsCount(Integer totalTransactionsCount) {
    this.totalTransactionsCount = totalTransactionsCount;
  }


  public BlockMetaDTO transactionsCount(Integer transactionsCount) {
    
    this.transactionsCount = transactionsCount;
    return this;
  }

   /**
   * Number of [transactions](https://docs.symbolplatform.com/concepts/transaction.html) confirmed in this block. This does not count *embedded* transactions (i.e. transactions contained within aggregate transactions). 
   * @return transactionsCount
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of [transactions](https://docs.symbolplatform.com/concepts/transaction.html) confirmed in this block. This does not count *embedded* transactions (i.e. transactions contained within aggregate transactions). ")
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTransactionsCount() {
    return transactionsCount;
  }


  public void setTransactionsCount(Integer transactionsCount) {
    this.transactionsCount = transactionsCount;
  }


  public BlockMetaDTO statementsCount(Integer statementsCount) {
    
    this.statementsCount = statementsCount;
    return this;
  }

   /**
   * Number of statements (of any kind) present in this block. Bear in mind that some of them (like [resolution statements](https://docs.symbolplatform.com/concepts/receipt.html#resolution-statement)) are triggered by transactions present in the block, but in general, [transaction statements](https://docs.symbolplatform.com/concepts/receipt.html#transaction-statement) are not. 
   * @return statementsCount
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of statements (of any kind) present in this block. Bear in mind that some of them (like [resolution statements](https://docs.symbolplatform.com/concepts/receipt.html#resolution-statement)) are triggered by transactions present in the block, but in general, [transaction statements](https://docs.symbolplatform.com/concepts/receipt.html#transaction-statement) are not. ")
  @JsonProperty(JSON_PROPERTY_STATEMENTS_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getStatementsCount() {
    return statementsCount;
  }


  public void setStatementsCount(Integer statementsCount) {
    this.statementsCount = statementsCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BlockMetaDTO blockMetaDTO = (BlockMetaDTO) o;
    return Objects.equals(this.hash, blockMetaDTO.hash) &&
        Objects.equals(this.totalFee, blockMetaDTO.totalFee) &&
        Objects.equals(this.generationHash, blockMetaDTO.generationHash) &&
        Objects.equals(this.stateHashSubCacheMerkleRoots, blockMetaDTO.stateHashSubCacheMerkleRoots) &&
        Objects.equals(this.totalTransactionsCount, blockMetaDTO.totalTransactionsCount) &&
        Objects.equals(this.transactionsCount, blockMetaDTO.transactionsCount) &&
        Objects.equals(this.statementsCount, blockMetaDTO.statementsCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hash, totalFee, generationHash, stateHashSubCacheMerkleRoots, totalTransactionsCount, transactionsCount, statementsCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BlockMetaDTO {\n");
    sb.append("    hash: ").append(toIndentedString(hash)).append("\n");
    sb.append("    totalFee: ").append(toIndentedString(totalFee)).append("\n");
    sb.append("    generationHash: ").append(toIndentedString(generationHash)).append("\n");
    sb.append("    stateHashSubCacheMerkleRoots: ").append(toIndentedString(stateHashSubCacheMerkleRoots)).append("\n");
    sb.append("    totalTransactionsCount: ").append(toIndentedString(totalTransactionsCount)).append("\n");
    sb.append("    transactionsCount: ").append(toIndentedString(transactionsCount)).append("\n");
    sb.append("    statementsCount: ").append(toIndentedString(statementsCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

