/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucket is created. Each bucket influences at most five importance recalculations. 
 */
@ApiModel(description = "Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucket is created. Each bucket influences at most five importance recalculations. ")
@JsonPropertyOrder({
  ActivityBucketDTO.JSON_PROPERTY_START_HEIGHT,
  ActivityBucketDTO.JSON_PROPERTY_TOTAL_FEES_PAID,
  ActivityBucketDTO.JSON_PROPERTY_BENEFICIARY_COUNT,
  ActivityBucketDTO.JSON_PROPERTY_RAW_SCORE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:35:16.459Z[UTC]")
public class ActivityBucketDTO {
  public static final String JSON_PROPERTY_START_HEIGHT = "startHeight";
  private java.math.BigInteger startHeight = null;

  public static final String JSON_PROPERTY_TOTAL_FEES_PAID = "totalFeesPaid";
  private java.math.BigInteger totalFeesPaid = null;

  public static final String JSON_PROPERTY_BENEFICIARY_COUNT = "beneficiaryCount";
  private Long beneficiaryCount;

  public static final String JSON_PROPERTY_RAW_SCORE = "rawScore";
  private java.math.BigInteger rawScore = null;


  public ActivityBucketDTO startHeight(java.math.BigInteger startHeight) {
    
    this.startHeight = startHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return startHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_START_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getStartHeight() {
    return startHeight;
  }


  public void setStartHeight(java.math.BigInteger startHeight) {
    this.startHeight = startHeight;
  }


  public ActivityBucketDTO totalFeesPaid(java.math.BigInteger totalFeesPaid) {
    
    this.totalFeesPaid = totalFeesPaid;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return totalFeesPaid
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_PAID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getTotalFeesPaid() {
    return totalFeesPaid;
  }


  public void setTotalFeesPaid(java.math.BigInteger totalFeesPaid) {
    this.totalFeesPaid = totalFeesPaid;
  }


  public ActivityBucketDTO beneficiaryCount(Long beneficiaryCount) {
    
    this.beneficiaryCount = beneficiaryCount;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return beneficiaryCount
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getBeneficiaryCount() {
    return beneficiaryCount;
  }


  public void setBeneficiaryCount(Long beneficiaryCount) {
    this.beneficiaryCount = beneficiaryCount;
  }


  public ActivityBucketDTO rawScore(java.math.BigInteger rawScore) {
    
    this.rawScore = rawScore;
    return this;
  }

   /**
   * Probability of an account to harvest the next block.
   * @return rawScore
  **/
  @ApiModelProperty(example = "0", required = true, value = "Probability of an account to harvest the next block.")
  @JsonProperty(JSON_PROPERTY_RAW_SCORE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getRawScore() {
    return rawScore;
  }


  public void setRawScore(java.math.BigInteger rawScore) {
    this.rawScore = rawScore;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityBucketDTO activityBucketDTO = (ActivityBucketDTO) o;
    return Objects.equals(this.startHeight, activityBucketDTO.startHeight) &&
        Objects.equals(this.totalFeesPaid, activityBucketDTO.totalFeesPaid) &&
        Objects.equals(this.beneficiaryCount, activityBucketDTO.beneficiaryCount) &&
        Objects.equals(this.rawScore, activityBucketDTO.rawScore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startHeight, totalFeesPaid, beneficiaryCount, rawScore);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityBucketDTO {\n");
    sb.append("    startHeight: ").append(toIndentedString(startHeight)).append("\n");
    sb.append("    totalFeesPaid: ").append(toIndentedString(totalFeesPaid)).append("\n");
    sb.append("    beneficiaryCount: ").append(toIndentedString(beneficiaryCount)).append("\n");
    sb.append("    rawScore: ").append(toIndentedString(rawScore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

