package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.FinalizationProofDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:35:16.459Z[UTC]")
public class FinalizationRoutesApiImpl implements FinalizationRoutesApi {

    private ApiClient apiClient;

    public FinalizationRoutesApiImpl() {
        this(null);
    }

    public FinalizationRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get finalization proof
     * Gets finalization proof for the greatest height associated with the given epoch.
     * @param epoch Finalization epoch. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getFinalizationProofAtEpoch(Long epoch, Handler<AsyncResult<FinalizationProofDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'epoch' is set
        if (epoch == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'epoch' when calling getFinalizationProofAtEpoch"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/finalization/proof/epoch/{epoch}".replaceAll("\\{" + "epoch" + "\\}", epoch.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<FinalizationProofDTO> localVarReturnType = new TypeReference<FinalizationProofDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get finalization proof
     * Gets finalization proof at the given height.
     * @param height Block height. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getFinalizationProofAtHeight(java.math.BigInteger height, Handler<AsyncResult<FinalizationProofDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getFinalizationProofAtHeight"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/finalization/proof/height/{height}".replaceAll("\\{" + "height" + "\\}", height.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<FinalizationProofDTO> localVarReturnType = new TypeReference<FinalizationProofDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
