package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockPage;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-03-13T17:52:01.950Z[UTC]")
public class SecretLockRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi delegate;

	public SecretLockRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get secret lock information
     * Gets the hash lock for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getSecretLock(String compositeHash, Handler<AsyncResult<SecretLockInfoDTO>> resultHandler) {
        delegate.getSecretLock(compositeHash, resultHandler);
    }

    /**
     * Get secret lock information
     * Gets the hash lock for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<SecretLockInfoDTO> rxGetSecretLock(String compositeHash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getSecretLock(compositeHash, fut);
        }));
    }
    /**
     * Get secret lock merkle information
     * Gets the hash lock merkle for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getSecretLockMerkle(String compositeHash, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getSecretLockMerkle(compositeHash, resultHandler);
    }

    /**
     * Get secret lock merkle information
     * Gets the hash lock merkle for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetSecretLockMerkle(String compositeHash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getSecretLockMerkle(compositeHash, fut);
        }));
    }
    /**
     * Search secret lock entries
     * Returns an array of secret locks.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param secret Filter by secret. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchSecretLock(String address, String secret, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<SecretLockPage>> resultHandler) {
        delegate.searchSecretLock(address, secret, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search secret lock entries
     * Returns an array of secret locks.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param secret Filter by secret. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<SecretLockPage> rxSearchSecretLock(String address, String secret, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchSecretLock(address, secret, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static SecretLockRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi arg) {
        return arg != null ? new SecretLockRoutesApi(arg) : null;
    }
}
