package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-03-13T17:52:01.950Z[UTC]")
public class RestrictionAccountRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate;

	public RestrictionAccountRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given address.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictions(String address, Handler<AsyncResult<AccountRestrictionsInfoDTO>> resultHandler) {
        delegate.getAccountRestrictions(address, resultHandler);
    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given address.
     * @param address Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountRestrictionsInfoDTO> rxGetAccountRestrictions(String address) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictions(address, fut);
        }));
    }
    /**
     * Get the account restrictions merkle
     * Returns the account restrictions merkle for a given address.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictionsMerkle(String address, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getAccountRestrictionsMerkle(address, resultHandler);
    }

    /**
     * Get the account restrictions merkle
     * Returns the account restrictions merkle for a given address.
     * @param address Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetAccountRestrictionsMerkle(String address) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictionsMerkle(address, fut);
        }));
    }
    /**
     * Search account restrictions
     * Returns an array of account restrictions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchAccountRestrictions(String address, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<AccountRestrictionsPage>> resultHandler) {
        delegate.searchAccountRestrictions(address, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search account restrictions
     * Returns an array of account restrictions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountRestrictionsPage> rxSearchAccountRestrictions(String address, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchAccountRestrictions(address, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static RestrictionAccountRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi arg) {
        return arg != null ? new RestrictionAccountRoutesApi(arg) : null;
    }
}
