package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Addresses;
import io.nem.symbol.sdk.openapi.vertx.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacePage;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-03-13T17:52:01.950Z[UTC]")
public class NamespaceRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi delegate;

	public NamespaceRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param addresses  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsNames(Addresses addresses, Handler<AsyncResult<AccountsNamesDTO>> resultHandler) {
        delegate.getAccountsNames(addresses, resultHandler);
    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param addresses  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountsNamesDTO> rxGetAccountsNames(Addresses addresses) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountsNames(addresses, fut);
        }));
    }
    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> resultHandler) {
        delegate.getMosaicsNames(mosaicIds, resultHandler);
    }

    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicsNamesDTO> rxGetMosaicsNames(MosaicIds mosaicIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicsNames(mosaicIds, fut);
        }));
    }
    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> resultHandler) {
        delegate.getNamespace(namespaceId, resultHandler);
    }

    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NamespaceInfoDTO> rxGetNamespace(String namespaceId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespace(namespaceId, fut);
        }));
    }
    /**
     * Get namespace merkle information
     * Gets the namespace merkle for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMerkle(String namespaceId, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getNamespaceMerkle(namespaceId, resultHandler);
    }

    /**
     * Get namespace merkle information
     * Gets the namespace merkle for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetNamespaceMerkle(String namespaceId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMerkle(namespaceId, fut);
        }));
    }
    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> resultHandler) {
        delegate.getNamespacesNames(namespaceIds, resultHandler);
    }

    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<NamespaceNameDTO>> rxGetNamespacesNames(NamespaceIds namespaceIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespacesNames(namespaceIds, fut);
        }));
    }
    /**
     * Search namespaces
     * Gets an array of namespaces.
     * @param ownerAddress Filter by owner address. (optional)
     * @param registrationType Filter by registration type. (optional)
     * @param level0 Filter by root namespace. (optional)
     * @param aliasType Filter by alias type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<NamespacePage>> resultHandler) {
        delegate.searchNamespaces(ownerAddress, registrationType, level0, aliasType, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search namespaces
     * Gets an array of namespaces.
     * @param ownerAddress Filter by owner address. (optional)
     * @param registrationType Filter by registration type. (optional)
     * @param level0 Filter by root namespace. (optional)
     * @param aliasType Filter by alias type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NamespacePage> rxSearchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchNamespaces(ownerAddress, registrationType, level0, aliasType, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static NamespaceRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi arg) {
        return arg != null ? new NamespaceRoutesApi(arg) : null;
    }
}
