package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataPage;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-03-13T17:52:01.950Z[UTC]")
public class MetadataRoutesApiImpl implements MetadataRoutesApi {

    private ApiClient apiClient;

    public MetadataRoutesApiImpl() {
        this(null);
    }

    public MetadataRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get metadata information
     * Gets the metadata for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMetadata(String compositeHash, Handler<AsyncResult<MetadataInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'compositeHash' is set
        if (compositeHash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'compositeHash' when calling getMetadata"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/{compositeHash}".replaceAll("\\{" + "compositeHash" + "\\}", compositeHash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataInfoDTO> localVarReturnType = new TypeReference<MetadataInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get metadata merkle information
     * Gets the metadata merkle for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMetadataMerkle(String compositeHash, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'compositeHash' is set
        if (compositeHash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'compositeHash' when calling getMetadataMerkle"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/{compositeHash}/merkle".replaceAll("\\{" + "compositeHash" + "\\}", compositeHash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleStateInfoDTO> localVarReturnType = new TypeReference<MerkleStateInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search metadata entries
     * Returns an array of metadata.
     * @param sourceAddress Filter by address sending the metadata entry. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param scopedMetadataKey Filter by metadata key. (optional)
     * @param targetId Filter by namespace or mosaic id. (optional)
     * @param metadataType Filter by metadata type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<MetadataPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/metadata";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sourceAddress", sourceAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetAddress", targetAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "scopedMetadataKey", scopedMetadataKey));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetId", targetId));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "metadataType", metadataType));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataPage> localVarReturnType = new TypeReference<MetadataPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
