/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountAddress", "minApproval", "minRemoval", "cosignatoryAddresses", "multisigAddresses"})
public class MultisigDTO {
    public static final String JSON_PROPERTY_ACCOUNT_ADDRESS = "accountAddress";
    private String accountAddress;
    public static final String JSON_PROPERTY_MIN_APPROVAL = "minApproval";
    private Long minApproval;
    public static final String JSON_PROPERTY_MIN_REMOVAL = "minRemoval";
    private Long minRemoval;
    public static final String JSON_PROPERTY_COSIGNATORY_ADDRESSES = "cosignatoryAddresses";
    private List<String> cosignatoryAddresses = new ArrayList<String>();
    public static final String JSON_PROPERTY_MULTISIG_ADDRESSES = "multisigAddresses";
    private List<String> multisigAddresses = new ArrayList<String>();

    public MultisigDTO accountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="accountAddress")
    public String getAccountAddress() {
        return this.accountAddress;
    }

    public void setAccountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
    }

    public MultisigDTO minApproval(Long minApproval) {
        this.minApproval = minApproval;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="minApproval")
    public Long getMinApproval() {
        return this.minApproval;
    }

    public void setMinApproval(Long minApproval) {
        this.minApproval = minApproval;
    }

    public MultisigDTO minRemoval(Long minRemoval) {
        this.minRemoval = minRemoval;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="minRemoval")
    public Long getMinRemoval() {
        return this.minRemoval;
    }

    public void setMinRemoval(Long minRemoval) {
        this.minRemoval = minRemoval;
    }

    public MultisigDTO cosignatoryAddresses(List<String> cosignatoryAddresses) {
        this.cosignatoryAddresses = cosignatoryAddresses;
        return this;
    }

    public MultisigDTO addCosignatoryAddressesItem(String cosignatoryAddressesItem) {
        this.cosignatoryAddresses.add(cosignatoryAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Addresses of the cosignatory accounts.")
    @JsonProperty(value="cosignatoryAddresses")
    public List<String> getCosignatoryAddresses() {
        return this.cosignatoryAddresses;
    }

    public void setCosignatoryAddresses(List<String> cosignatoryAddresses) {
        this.cosignatoryAddresses = cosignatoryAddresses;
    }

    public MultisigDTO multisigAddresses(List<String> multisigAddresses) {
        this.multisigAddresses = multisigAddresses;
        return this;
    }

    public MultisigDTO addMultisigAddressesItem(String multisigAddressesItem) {
        this.multisigAddresses.add(multisigAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Multisig accounts where the account is cosignatory.")
    @JsonProperty(value="multisigAddresses")
    public List<String> getMultisigAddresses() {
        return this.multisigAddresses;
    }

    public void setMultisigAddresses(List<String> multisigAddresses) {
        this.multisigAddresses = multisigAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigDTO multisigDTO = (MultisigDTO)o;
        return Objects.equals(this.accountAddress, multisigDTO.accountAddress) && Objects.equals(this.minApproval, multisigDTO.minApproval) && Objects.equals(this.minRemoval, multisigDTO.minRemoval) && Objects.equals(this.cosignatoryAddresses, multisigDTO.cosignatoryAddresses) && Objects.equals(this.multisigAddresses, multisigDTO.multisigAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.accountAddress, this.minApproval, this.minRemoval, this.cosignatoryAddresses, this.multisigAddresses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigDTO {\n");
        sb.append("    accountAddress: ").append(this.toIndentedString(this.accountAddress)).append("\n");
        sb.append("    minApproval: ").append(this.toIndentedString(this.minApproval)).append("\n");
        sb.append("    minRemoval: ").append(this.toIndentedString(this.minRemoval)).append("\n");
        sb.append("    cosignatoryAddresses: ").append(this.toIndentedString(this.cosignatoryAddresses)).append("\n");
        sb.append("    multisigAddresses: ").append(this.toIndentedString(this.multisigAddresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

